/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.pooling.SingletonPool;
import org.jbox2d.pooling.TLVec2;
import org.jbox2d.pooling.TLXForm;

public class TOI {
    private static final TLXForm tlxf1 = new TLXForm();
    private static final TLXForm tlxf2 = new TLXForm();
    private static final TLVec2 tlP1 = new TLVec2();
    private static final TLVec2 tlP2 = new TLVec2();

    public static final float timeOfImpact(Shape shape1, Sweep sweep1, Shape shape2, Sweep sweep2) {
        XForm xf1 = (XForm)tlxf1.get();
        XForm xf2 = (XForm)tlxf2.get();
        Vec2 p1 = (Vec2)tlP1.get();
        Vec2 p2 = (Vec2)tlP2.get();
        float r1 = shape1.getSweepRadius();
        float r2 = shape2.getSweepRadius();
        assert (sweep1.t0 == sweep2.t0);
        assert (1.0f - sweep1.t0 > 1.1920929E-7f);
        float t0 = sweep1.t0;
        float vx = sweep1.c.x - sweep1.c0.x - (sweep2.c.x - sweep2.c0.x);
        float vy = sweep1.c.y - sweep1.c0.y - (sweep2.c.y - sweep2.c0.y);
        float omega1 = sweep1.a - sweep1.a0;
        float omega2 = sweep2.a - sweep2.a0;
        float alpha = 0.0f;
        int k_maxIterations = 20;
        int iter = 0;
        float distance = 0.0f;
        float targetDistance = 0.0f;
        while (true) {
            float approachVelocityBound;
            float t = (1.0f - alpha) * t0 + alpha;
            sweep1.getXForm(xf1, t);
            sweep2.getXForm(xf2, t);
            distance = SingletonPool.getDistance().distance(p1, p2, shape1, xf1, shape2, xf2);
            if (iter == 0) {
                targetDistance = distance > 0.08f ? 0.06f : MathUtils.max(0.002f, distance - 0.02f);
            }
            if (distance - targetDistance < 0.002f || iter == 20) break;
            float normalx = p2.x - p1.x;
            float normaly = p2.y - p1.y;
            float lenSqrd = normalx * normalx + normaly * normaly;
            if (lenSqrd >= 1.4210855E-14f) {
                float length = MathUtils.sqrt(lenSqrd);
                float invLength = 1.0f / length;
                normalx *= invLength;
                normaly *= invLength;
            }
            if (MathUtils.abs(approachVelocityBound = normalx * vx + normaly * vy + MathUtils.abs(omega1) * r1 + MathUtils.abs(omega2) * r2) < 1.1920929E-7f) {
                alpha = 1.0f;
                break;
            }
            float dAlpha = (distance - targetDistance) / approachVelocityBound;
            float newAlpha = alpha + dAlpha;
            if (newAlpha < 0.0f || 1.0f < newAlpha) {
                alpha = 1.0f;
                break;
            }
            if (newAlpha < 1.0000119f * alpha) break;
            alpha = newAlpha;
            ++iter;
        }
        return alpha;
    }
}

