/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Point;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PointShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public final class Distance {
    public int g_GJK_Iterations = 0;
    private final Vec2[] p1s = new Vec2[3];
    private final Vec2[] p2s = new Vec2[3];
    private final Vec2[] points = new Vec2[3];
    private final Vec2 v = new Vec2();
    private final Vec2 vNeg = new Vec2();
    private final Vec2 w = new Vec2();
    private final Vec2 w1 = new Vec2();
    private final Vec2 w2 = new Vec2();
    private final Vec2 p2r = new Vec2();
    private final Vec2 p2d = new Vec2();
    private final Vec2 distCCp1 = new Vec2();
    private final Vec2 distCCp2 = new Vec2();
    private final Vec2 distCCd = new Vec2();
    private final Vec2 cWorld = new Vec2();
    private final Vec2 ECcLocal = new Vec2();
    private final Vec2 ECvWorld = new Vec2();
    private final Vec2 ECd = new Vec2();
    private final Vec2 ECtemp = new Vec2();
    private final Point point = new Point();
    private final Vec2 CPp1 = new Vec2();
    private final Vec2 CPp2 = new Vec2();
    private final Vec2 CPd = new Vec2();

    public Distance() {
        int i = 0;
        while (i < 3) {
            this.p1s[i] = new Vec2();
            this.p2s[i] = new Vec2();
            this.points[i] = new Vec2();
            ++i;
        }
    }

    protected final int ProcessTwo(Vec2 x1, Vec2 x2, Vec2[] p1s, Vec2[] p2s, Vec2[] points) {
        this.p2r.x = -points[1].x;
        this.p2r.y = -points[1].y;
        this.p2d.x = points[0].x - points[1].x;
        this.p2d.y = points[0].y - points[1].y;
        float length = this.p2d.normalize();
        float lambda = Vec2.dot(this.p2r, this.p2d);
        if (lambda <= 0.0f || length < 1.1920929E-7f) {
            x1.set(p1s[1]);
            x2.set(p2s[1]);
            p1s[0].set(p1s[1]);
            p2s[0].set(p2s[1]);
            points[0].set(points[1]);
            return 1;
        }
        x1.set(p1s[1].x + (lambda /= length) * (p1s[0].x - p1s[1].x), p1s[1].y + lambda * (p1s[0].y - p1s[1].y));
        x2.set(p2s[1].x + lambda * (p2s[0].x - p2s[1].x), p2s[1].y + lambda * (p2s[0].y - p2s[1].y));
        return 2;
    }

    protected final int ProcessThree(Vec2 x1, Vec2 x2, Vec2[] p1s, Vec2[] p2s, Vec2[] points) {
        Vec2 a = points[0];
        Vec2 b = points[1];
        Vec2 c = points[2];
        float abx = b.x - a.x;
        float aby = b.y - a.y;
        float acx = c.x - a.x;
        float acy = c.y - a.y;
        float bcx = c.x - b.x;
        float bcy = c.y - b.y;
        float sn = -(a.x * abx + a.y * aby);
        float sd = b.x * abx + b.y * aby;
        float tn = -(a.x * acx + a.y * acy);
        float td = c.x * acx + c.y * acy;
        float un = -(b.x * bcx + b.y * bcy);
        float ud = c.x * bcx + c.y * bcy;
        if (td <= 0.0f && ud <= 0.0f) {
            x1.set(p1s[2]);
            x2.set(p2s[2]);
            p1s[0].set(p1s[2]);
            p2s[0].set(p2s[2]);
            points[0].set(points[2]);
            return 1;
        }
        assert (sn > 0.0f || tn > 0.0f);
        assert (sd > 0.0f || un > 0.0f);
        float n = abx * acy - aby * acx;
        float vc = n * Vec2.cross(a, b);
        assert (vc > 0.0f || sn > 0.0f || sd > 0.0f);
        float va = n * Vec2.cross(b, c);
        if (va <= 0.0f && un >= 0.0f && ud >= 0.0f && un + ud > 0.0f) {
            assert (un + ud > 0.0f);
            float lambda = un / (un + ud);
            x1.set(p1s[1].x + lambda * (p1s[2].x - p1s[1].x), p1s[1].y + lambda * (p1s[2].y - p1s[1].y));
            x2.set(p2s[1].x + lambda * (p2s[2].x - p2s[1].x), p2s[1].y + lambda * (p2s[2].y - p2s[1].y));
            p1s[0].set(p1s[2]);
            p2s[0].set(p2s[2]);
            points[0].set(points[2]);
            return 2;
        }
        float vb = n * Vec2.cross(c, a);
        if (vb <= 0.0f && tn >= 0.0f && td >= 0.0f && tn + td > 0.0f) {
            assert (tn + td > 0.0f);
            float lambda = tn / (tn + td);
            x1.set(p1s[0].x + lambda * (p1s[2].x - p1s[0].x), p1s[0].y + lambda * (p1s[2].y - p1s[0].y));
            x2.set(p2s[0].x + lambda * (p2s[2].x - p2s[0].x), p2s[0].y + lambda * (p2s[2].y - p2s[0].y));
            p1s[1].set(p1s[2]);
            p2s[1].set(p2s[2]);
            points[1].set(points[2]);
            return 2;
        }
        float denom = va + vb + vc;
        assert (denom > 0.0f);
        denom = 1.0f / denom;
        float u = va * denom;
        float v = vb * denom;
        float w = 1.0f - u - v;
        x1.set(u * p1s[0].x + v * p1s[1].x + w * p1s[2].x, u * p1s[0].y + v * p1s[1].y + w * p1s[2].y);
        x2.set(u * p2s[0].x + v * p2s[1].x + w * p2s[2].x, u * p2s[0].y + v * p2s[1].y + w * p2s[2].y);
        return 3;
    }

    public final boolean InPoints(Vec2 w, Vec2[] points, int pointCount) {
        float k_tolerance = 1.1920929E-5f;
        int i = 0;
        while (i < pointCount) {
            Vec2 v = points[i];
            float dx = MathUtils.abs(w.x - v.x);
            float dy = MathUtils.abs(w.y - v.y);
            float mx = MathUtils.max(MathUtils.abs(w.x), MathUtils.abs(points[i].x));
            float my = MathUtils.max(MathUtils.abs(w.y), MathUtils.abs(points[i].y));
            if (dx < 1.1920929E-5f * (mx + 1.0f) && dy < 1.1920929E-5f * (my + 1.0f)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final float DistanceGeneric(Vec2 x1, Vec2 x2, SupportsGenericDistance shape1, XForm xf1, SupportsGenericDistance shape2, XForm xf2) {
        int pointCount = 0;
        shape1.getFirstVertexToOut(xf1, x1);
        shape2.getFirstVertexToOut(xf2, x2);
        float vSqr = 0.0f;
        int maxIterations = 20;
        int iter = 0;
        while (iter < 20) {
            this.v.set(x2.x - x1.x, x2.y - x1.y);
            shape1.support(this.w1, xf1, this.v);
            this.vNeg.set(-this.v.x, -this.v.y);
            shape2.support(this.w2, xf2, this.vNeg);
            vSqr = Vec2.dot(this.v, this.v);
            this.w.set(this.w2.x - this.w1.x, this.w2.y - this.w1.y);
            float vw = Vec2.dot(this.v, this.w);
            if (vSqr - vw <= 0.01f * vSqr || this.InPoints(this.w, this.points, pointCount)) {
                if (pointCount == 0) {
                    x1.set(this.w1);
                    x2.set(this.w2);
                }
                this.g_GJK_Iterations = iter;
                return MathUtils.sqrt(vSqr);
            }
            switch (pointCount) {
                case 0: {
                    this.p1s[0].set(this.w1);
                    this.p2s[0].set(this.w2);
                    this.points[0].set(this.w);
                    x1.set(this.p1s[0]);
                    x2.set(this.p2s[0]);
                    ++pointCount;
                    break;
                }
                case 1: {
                    this.p1s[1].set(this.w1);
                    this.p2s[1].set(this.w2);
                    this.points[1].set(this.w);
                    pointCount = this.ProcessTwo(x1, x2, this.p1s, this.p2s, this.points);
                    break;
                }
                case 2: {
                    this.p1s[2].set(this.w1);
                    this.p2s[2].set(this.w2);
                    this.points[2].set(this.w);
                    pointCount = this.ProcessThree(x1, x2, this.p1s, this.p2s, this.points);
                }
            }
            if (pointCount == 3) {
                this.g_GJK_Iterations = iter;
                return 0.0f;
            }
            float maxSqr = -3.4028235E38f;
            int i = 0;
            while (i < pointCount) {
                maxSqr = MathUtils.max(maxSqr, Vec2.dot(this.points[i], this.points[i]));
                ++i;
            }
            if (pointCount == 3 || vSqr <= 1.1920929E-5f * maxSqr) {
                this.g_GJK_Iterations = iter;
                float vx = x2.x - x1.x;
                float vy = x2.y - x1.y;
                vSqr = vx * vx + vy * vy;
                return MathUtils.sqrt(vSqr);
            }
            ++iter;
        }
        this.g_GJK_Iterations = 20;
        return MathUtils.sqrt(vSqr);
    }

    public final float DistanceCC(Vec2 x1, Vec2 x2, CircleShape circle1, XForm xf1, CircleShape circle2, XForm xf2) {
        XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.distCCp1);
        XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.distCCp2);
        this.distCCd.x = this.distCCp2.x - this.distCCp1.x;
        this.distCCd.y = this.distCCp2.y - this.distCCp1.y;
        float dSqr = Vec2.dot(this.distCCd, this.distCCd);
        float r1 = circle1.getRadius() - 0.04f;
        float r2 = circle2.getRadius() - 0.04f;
        float r = r1 + r2;
        if (dSqr > r * r) {
            float dLen = this.distCCd.normalize();
            float distance = dLen - r;
            x1.set(this.distCCp1.x + r1 * this.distCCd.x, this.distCCp1.y + r1 * this.distCCd.y);
            x2.set(this.distCCp2.x - r2 * this.distCCd.x, this.distCCp2.y - r2 * this.distCCd.y);
            return distance;
        }
        if (dSqr > 1.4210855E-14f) {
            this.distCCd.normalize();
            x1.set(this.distCCp1.x + r1 * this.distCCd.x, this.distCCp1.y + r1 * this.distCCd.y);
            x2.set(x1);
            return 0.0f;
        }
        x1.set(this.distCCp1);
        x2.set(x1);
        return 0.0f;
    }

    public final float DistanceEdgeCircle(Vec2 x1, Vec2 x2, EdgeShape edge, XForm xf1, CircleShape circle, XForm xf2) {
        float r = circle.getRadius() - 0.04f;
        XForm.mulToOut(xf2, circle.getMemberLocalPosition(), this.cWorld);
        XForm.mulTransToOut(xf1, this.cWorld, this.ECcLocal);
        float dirDist = Vec2.dot(this.ECcLocal.sub(edge.getCoreVertex1()), edge.getDirectionVector());
        if (dirDist <= 0.0f) {
            XForm.mulToOut(xf1, edge.getCoreVertex1(), this.ECvWorld);
        } else if (dirDist >= edge.getLength()) {
            XForm.mulToOut(xf1, edge.getCoreVertex2(), this.ECvWorld);
        } else {
            x1.set(edge.getDirectionVector());
            x1.mulLocal(dirDist).addLocal(edge.getCoreVertex1());
            XForm.mulToOut(xf1, x1, x1);
            this.ECtemp.set(this.ECcLocal);
            this.ECtemp.subLocal(edge.getCoreVertex1());
            float dLen = Vec2.dot(this.ECtemp, edge.getNormalVector());
            if (dLen < 0.0f) {
                if (dLen < -r) {
                    x2.set(edge.getNormalVector());
                    x2.mulLocal(r).addLocal(this.ECcLocal);
                    XForm.mulToOut(xf1, x2, x2);
                    return -dLen - r;
                }
                x2.set(x1);
                return 0.0f;
            }
            if (dLen > r) {
                x2.set(edge.getNormalVector());
                x2.mulLocal(r).subLocal(this.ECcLocal).negateLocal();
                XForm.mulToOut(xf1, x2, x2);
                return dLen - r;
            }
            x2.set(x1);
            return 0.0f;
        }
        x1.set(this.ECvWorld);
        this.ECd.set(this.cWorld);
        this.ECd.subLocal(this.ECvWorld);
        float dSqr = Vec2.dot(this.ECd, this.ECd);
        if (dSqr > r * r) {
            float dLen = this.ECd.normalize();
            x2.set(this.ECd);
            x2.mulLocal(r).subLocal(this.cWorld).negateLocal();
            return dLen - r;
        }
        x2.set(this.ECvWorld);
        return 0.0f;
    }

    public final float DistancePC(Vec2 x1, Vec2 x2, PolygonShape polygon, XForm xf1, CircleShape circle, XForm xf2) {
        this.point.p.set(xf2.position.x + xf2.R.col1.x * circle.m_localPosition.x + xf2.R.col2.x * circle.m_localPosition.y, xf2.position.y + xf2.R.col1.y * circle.m_localPosition.x + xf2.R.col2.y * circle.m_localPosition.y);
        float distance = this.DistanceGeneric(x1, x2, polygon, xf1, this.point, XForm.identity);
        float r = circle.getRadius() - 0.04f;
        if (distance > r) {
            distance -= r;
            float dx = x2.x - x1.x;
            float dy = x2.y - x1.y;
            float length = MathUtils.sqrt(dx * dx + dy * dy);
            if (length >= 1.1920929E-7f) {
                float invLength = 1.0f / length;
                dx *= invLength;
                dy *= invLength;
            }
            x2.x -= r * dx;
            x2.y -= r * dy;
        } else {
            distance = 0.0f;
            x2.set(x1);
        }
        return distance;
    }

    public final float DistancePolygonPoint(Vec2 x1, Vec2 x2, PolygonShape polygon, XForm xf1, PointShape pt, XForm xf2) {
        this.point.p.set(xf2.position.x + xf2.R.col1.x * pt.m_localPosition.x + xf2.R.col2.x * pt.m_localPosition.y, xf2.position.y + xf2.R.col1.y * pt.m_localPosition.x + xf2.R.col2.y * pt.m_localPosition.y);
        float distance = this.DistanceGeneric(x1, x2, polygon, xf1, this.point, XForm.identity);
        float r = -0.04f;
        if (distance > -0.04f) {
            distance -= -0.04f;
            float dx = x2.x - x1.x;
            float dy = x2.y - x1.y;
            float length = MathUtils.sqrt(dx * dx + dy * dy);
            if (length >= 1.1920929E-7f) {
                float invLength = 1.0f / length;
                dx *= invLength;
                dy *= invLength;
            }
            x2.x -= -0.04f * dx;
            x2.y -= -0.04f * dy;
        } else {
            distance = 0.0f;
            x2.set(x1);
        }
        return distance;
    }

    public final float DistanceCirclePoint(Vec2 x1, Vec2 x2, CircleShape circle1, XForm xf1, PointShape pt2, XForm xf2) {
        XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.CPp1);
        XForm.mulToOut(xf2, pt2.getMemberLocalPosition(), this.CPp2);
        this.CPd.x = this.CPp2.x - this.CPp1.x;
        this.CPd.y = this.CPp2.y - this.CPp1.y;
        float dSqr = Vec2.dot(this.CPd, this.CPd);
        float r1 = circle1.getRadius() - 0.04f;
        float r2 = -0.04f;
        float r = r1 + -0.04f;
        if (dSqr > r * r) {
            float dLen = this.CPd.normalize();
            float distance = dLen - r;
            x1.set(this.CPp1.x + r1 * this.CPd.x, this.CPp1.y + r1 * this.CPd.y);
            x2.set(this.CPp2.x - -0.04f * this.CPd.x, this.CPp2.y - -0.04f * this.CPd.y);
            return distance;
        }
        if (dSqr > 1.4210855E-14f) {
            this.CPd.normalize();
            x1.set(this.CPp1.x + r1 * this.CPd.x, this.CPp1.y + r1 * this.CPd.y);
            x2.set(x1);
            return 0.0f;
        }
        x1.set(this.CPp1);
        x2.set(x1);
        return 0.0f;
    }

    public final float distance(Vec2 x1, Vec2 x2, Shape shape1, XForm xf1, Shape shape2, XForm xf2) {
        ShapeType type1 = shape1.getType();
        ShapeType type2 = shape2.getType();
        if (type1 == ShapeType.CIRCLE_SHAPE && type2 == ShapeType.CIRCLE_SHAPE) {
            return this.DistanceCC(x1, x2, (CircleShape)shape1, xf1, (CircleShape)shape2, xf2);
        }
        if (type1 == ShapeType.POLYGON_SHAPE && type2 == ShapeType.CIRCLE_SHAPE) {
            return this.DistancePC(x1, x2, (PolygonShape)shape1, xf1, (CircleShape)shape2, xf2);
        }
        if (type1 == ShapeType.CIRCLE_SHAPE && type2 == ShapeType.POLYGON_SHAPE) {
            return this.DistancePC(x2, x1, (PolygonShape)shape2, xf2, (CircleShape)shape1, xf1);
        }
        if (type1 == ShapeType.POLYGON_SHAPE && type2 == ShapeType.POLYGON_SHAPE) {
            return this.DistanceGeneric(x1, x2, (PolygonShape)shape1, xf1, (PolygonShape)shape2, xf2);
        }
        if (type1 == ShapeType.EDGE_SHAPE && type2 == ShapeType.CIRCLE_SHAPE) {
            return this.DistanceEdgeCircle(x1, x2, (EdgeShape)shape1, xf1, (CircleShape)shape2, xf2);
        }
        if (type1 == ShapeType.CIRCLE_SHAPE && type2 == ShapeType.EDGE_SHAPE) {
            return this.DistanceEdgeCircle(x2, x1, (EdgeShape)shape2, xf2, (CircleShape)shape1, xf1);
        }
        if (type1 == ShapeType.POLYGON_SHAPE && type2 == ShapeType.EDGE_SHAPE) {
            return this.DistanceGeneric(x2, x1, (EdgeShape)shape2, xf2, (PolygonShape)shape1, xf1);
        }
        if (type1 == ShapeType.EDGE_SHAPE && type2 == ShapeType.POLYGON_SHAPE) {
            return this.DistanceGeneric(x1, x2, (EdgeShape)shape1, xf1, (PolygonShape)shape2, xf2);
        }
        if (type1 == ShapeType.POINT_SHAPE && type2 == ShapeType.POINT_SHAPE) {
            return Float.MAX_VALUE;
        }
        if (type1 == ShapeType.POINT_SHAPE && type2 == ShapeType.CIRCLE_SHAPE) {
            return this.DistanceCirclePoint(x2, x1, (CircleShape)shape2, xf2, (PointShape)shape1, xf1);
        }
        if (type1 == ShapeType.CIRCLE_SHAPE && type2 == ShapeType.POINT_SHAPE) {
            return this.DistanceCirclePoint(x1, x2, (CircleShape)shape1, xf1, (PointShape)shape2, xf2);
        }
        if (type1 == ShapeType.POINT_SHAPE && type2 == ShapeType.POLYGON_SHAPE) {
            return this.DistancePolygonPoint(x2, x1, (PolygonShape)shape2, xf2, (PointShape)shape1, xf1);
        }
        if (type1 == ShapeType.POLYGON_SHAPE && type2 == ShapeType.POINT_SHAPE) {
            return this.DistancePolygonPoint(x1, x2, (PolygonShape)shape1, xf1, (PointShape)shape2, xf2);
        }
        return 0.0f;
    }
}

