/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import java.util.Arrays;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Bound;
import org.jbox2d.collision.BoundValues;
import org.jbox2d.collision.BufferedPair;
import org.jbox2d.collision.PairCallback;
import org.jbox2d.collision.PairManager;
import org.jbox2d.collision.Proxy;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SortKeyFunc;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.TLBoundValues;
import org.jbox2d.pooling.arrays.IntegerArray;

public class BroadPhase {
    public static final int INVALID = Integer.MAX_VALUE;
    public static final int NULL_EDGE = Integer.MAX_VALUE;
    public PairManager m_pairManager;
    public Proxy[] m_proxyPool;
    int m_freeProxy;
    BufferedPair[] pairBuffer;
    int m_pairBufferCount;
    public Bound[][] m_bounds;
    int[] m_queryResults;
    float[] m_querySortKeys = new float[64];
    int m_queryResultCount;
    public AABB m_worldAABB;
    public Vec2 m_quantizationFactor;
    public int m_proxyCount;
    int m_timeStamp;
    public static final boolean debugPrint = false;
    public static final boolean s_validate = false;
    private static final IntegerArray tlLowerValues = new IntegerArray();
    private static final IntegerArray tlUpperValues = new IntegerArray();
    private static final IntegerArray tlIndexes = new IntegerArray();
    private static final IntegerArray tlIgnored = new IntegerArray();
    private static final TLBoundValues tlNewValues = new TLBoundValues();
    private static final TLBoundValues tlOldValues = new TLBoundValues();
    private static final IntegerArray tlResults = new IntegerArray();

    private void dump() {
        System.out.println("*****DUMP START");
        int i = 0;
        while (i < 100) {
            System.out.println("bounds[ " + i + " ] = " + this.m_bounds[0][i].value + ", " + this.m_bounds[1][i].value + " \n");
            ++i;
        }
        i = 0;
        while (i < this.m_proxyPool.length) {
            Proxy p = this.m_proxyPool[i];
            if (p != null) {
                System.out.println("proxy#" + i + ": valid=" + p.isValid() + " userData=" + " upperBounds=" + Arrays.asList(new int[][]{p.upperBounds}) + " lowerBounds=" + Arrays.asList(new int[][]{p.lowerBounds}) + " timeStamp=" + p.timeStamp + " overlapCount=" + p.overlapCount + " next=" + p.getNext());
            }
            ++i;
        }
        System.out.println("*****DUMP END");
    }

    public BroadPhase(AABB worldAABB, PairCallback callback) {
        this.m_proxyPool = new Proxy[64];
        this.pairBuffer = new BufferedPair[4096];
        this.m_bounds = new Bound[2][128];
        this.m_queryResults = new int[64];
        int i = 0;
        while (i < 128) {
            this.m_bounds[0][i] = new Bound();
            this.m_bounds[1][i] = new Bound();
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.pairBuffer[i] = new BufferedPair();
            ++i;
        }
        this.m_pairManager = new PairManager();
        this.m_pairManager.initialize(this, callback);
        assert (worldAABB.isValid());
        this.m_worldAABB = new AABB(worldAABB);
        this.m_proxyCount = 0;
        Vec2 d = worldAABB.upperBound.sub(worldAABB.lowerBound);
        this.m_quantizationFactor = new Vec2(2.1474836E9f / d.x, 2.1474836E9f / d.y);
        int i2 = 0;
        while (i2 < 63) {
            this.m_proxyPool[i2] = new Proxy();
            this.m_proxyPool[i2].setNext(i2 + 1);
            this.m_proxyPool[i2].timeStamp = 0;
            this.m_proxyPool[i2].overlapCount = Integer.MAX_VALUE;
            this.m_proxyPool[i2].userData = null;
            ++i2;
        }
        this.m_proxyPool[63] = new Proxy();
        this.m_proxyPool[63].setNext(Integer.MAX_VALUE);
        this.m_proxyPool[63].timeStamp = 0;
        this.m_proxyPool[63].overlapCount = Integer.MAX_VALUE;
        this.m_proxyPool[63].userData = null;
        this.m_freeProxy = 0;
        this.m_timeStamp = 1;
        this.m_queryResultCount = 0;
    }

    protected boolean testOverlap(Proxy p1, Proxy p2) {
        int axis = 0;
        while (axis < 2) {
            Bound[] bounds = this.m_bounds[axis];
            assert (p1.lowerBounds[axis] < 2 * this.m_proxyCount);
            assert (p1.upperBounds[axis] < 2 * this.m_proxyCount);
            assert (p2.lowerBounds[axis] < 2 * this.m_proxyCount);
            assert (p2.upperBounds[axis] < 2 * this.m_proxyCount);
            if (bounds[p1.lowerBounds[axis]].value > bounds[p2.upperBounds[axis]].value) {
                return false;
            }
            if (bounds[p1.upperBounds[axis]].value < bounds[p2.lowerBounds[axis]].value) {
                return false;
            }
            ++axis;
        }
        return true;
    }

    private boolean testOverlap(BoundValues b, Proxy p) {
        int axis = 0;
        while (axis < 2) {
            Bound[] bounds = this.m_bounds[axis];
            assert (p.lowerBounds[axis] < 2 * this.m_proxyCount);
            assert (p.upperBounds[axis] < 2 * this.m_proxyCount);
            if (bounds[p.upperBounds[axis]] != null && b.lowerValues[axis] > bounds[p.upperBounds[axis]].value) {
                return false;
            }
            if (bounds[p.lowerBounds[axis]] != null && b.upperValues[axis] < bounds[p.lowerBounds[axis]].value) {
                return false;
            }
            ++axis;
        }
        return true;
    }

    public Proxy getProxy(int proxyId) {
        if (proxyId == Integer.MAX_VALUE || !this.m_proxyPool[proxyId].isValid()) {
            return null;
        }
        return this.m_proxyPool[proxyId];
    }

    public int createProxy(AABB aabb, Object userData) {
        assert (this.m_proxyCount < 64);
        assert (this.m_freeProxy != Integer.MAX_VALUE);
        int proxyId = this.m_freeProxy;
        Proxy proxy = this.m_proxyPool[proxyId];
        this.m_freeProxy = proxy.getNext();
        proxy.overlapCount = 0;
        proxy.userData = userData;
        int boundCount = 2 * this.m_proxyCount;
        Integer[] lowerValues = (Integer[])tlLowerValues.get(2);
        Integer[] upperValues = (Integer[])tlUpperValues.get(2);
        Integer[] indexes = (Integer[])tlIndexes.get(2);
        this.computeBounds(lowerValues, upperValues, aabb);
        int axis = 0;
        while (axis < 2) {
            Bound[] bounds = this.m_bounds[axis];
            this.query(indexes, lowerValues[axis], upperValues[axis], bounds, boundCount, axis);
            int lowerIndex = indexes[0];
            int upperIndex = indexes[1];
            System.arraycopy(this.m_bounds[axis], upperIndex, this.m_bounds[axis], upperIndex + 2, boundCount - upperIndex);
            int i = 0;
            while (i < boundCount - upperIndex) {
                this.m_bounds[axis][upperIndex + 2 + i] = new Bound(this.m_bounds[axis][upperIndex + 2 + i]);
                ++i;
            }
            System.arraycopy(this.m_bounds[axis], lowerIndex, this.m_bounds[axis], lowerIndex + 1, upperIndex - lowerIndex);
            i = 0;
            while (i < upperIndex - lowerIndex) {
                this.m_bounds[axis][lowerIndex + 1 + i] = new Bound(this.m_bounds[axis][lowerIndex + 1 + i]);
                ++i;
            }
            ++upperIndex;
            assert (bounds[lowerIndex] != null) : "Null pointer (lower)";
            assert (bounds[upperIndex] != null) : "Null pointer (upper)";
            bounds[lowerIndex].setValueInternal(lowerValues[axis]);
            bounds[lowerIndex].proxyId = proxyId;
            bounds[upperIndex].setValueInternal(upperValues[axis]);
            bounds[upperIndex].proxyId = proxyId;
            bounds[lowerIndex].stabbingCount = lowerIndex == 0 ? 0 : bounds[lowerIndex - 1].stabbingCount;
            bounds[upperIndex].stabbingCount = bounds[upperIndex - 1].stabbingCount;
            int index = lowerIndex;
            while (index < upperIndex) {
                ++bounds[index].stabbingCount;
                ++index;
            }
            index = lowerIndex;
            while (index < boundCount + 2) {
                Proxy proxyn = this.m_proxyPool[bounds[index].proxyId];
                if (bounds[index].isLower()) {
                    proxyn.lowerBounds[axis] = index;
                } else {
                    proxyn.upperBounds[axis] = index;
                }
                ++index;
            }
            ++axis;
        }
        ++this.m_proxyCount;
        assert (this.m_queryResultCount < 64);
        int i = 0;
        while (i < this.m_queryResultCount) {
            assert (this.m_queryResults[i] < 64);
            assert (this.m_proxyPool[this.m_queryResults[i]].isValid());
            this.m_pairManager.addBufferedPair(proxyId, this.m_queryResults[i]);
            ++i;
        }
        this.m_pairManager.commit();
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        return proxyId;
    }

    public void destroyProxy(int proxyId) {
        assert (this.m_proxyCount > 0 && this.m_proxyCount <= 64);
        Proxy proxy = this.m_proxyPool[proxyId];
        assert (proxy.isValid());
        int boundCount = 2 * this.m_proxyCount;
        Integer[] ignored = (Integer[])tlIgnored.get(2);
        int axis = 0;
        while (axis < 2) {
            Bound[] bounds = this.m_bounds[axis];
            int lowerIndex = proxy.lowerBounds[axis];
            int upperIndex = proxy.upperBounds[axis];
            int lowerValue = bounds[lowerIndex].value;
            int upperValue = bounds[upperIndex].value;
            System.arraycopy(this.m_bounds[axis], lowerIndex + 1, this.m_bounds[axis], lowerIndex, upperIndex - lowerIndex - 1);
            int i = 0;
            while (i < upperIndex - lowerIndex - 1) {
                this.m_bounds[axis][lowerIndex + i] = new Bound(this.m_bounds[axis][lowerIndex + i]);
                ++i;
            }
            System.arraycopy(this.m_bounds[axis], upperIndex + 1, this.m_bounds[axis], upperIndex - 1, boundCount - upperIndex - 1);
            i = 0;
            while (i < boundCount - upperIndex - 1) {
                this.m_bounds[axis][upperIndex - 1 + i] = new Bound(this.m_bounds[axis][upperIndex - 1 + i]);
                ++i;
            }
            int index = lowerIndex;
            while (index < boundCount - 2) {
                Proxy proxyn = this.m_proxyPool[bounds[index].proxyId];
                if (bounds[index].isLower()) {
                    proxyn.lowerBounds[axis] = index;
                } else {
                    proxyn.upperBounds[axis] = index;
                }
                ++index;
            }
            index = lowerIndex;
            while (index < upperIndex - 1) {
                --bounds[index].stabbingCount;
                ++index;
            }
            this.query(ignored, lowerValue, upperValue, bounds, boundCount - 2, axis);
            ++axis;
        }
        assert (this.m_queryResultCount < 64);
        int i = 0;
        while (i < this.m_queryResultCount) {
            assert (this.m_proxyPool[this.m_queryResults[i]].isValid());
            this.m_pairManager.removeBufferedPair(proxyId, this.m_queryResults[i]);
            ++i;
        }
        this.m_pairManager.commit();
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        proxy.userData = null;
        proxy.overlapCount = Integer.MAX_VALUE;
        proxy.lowerBounds[0] = Integer.MAX_VALUE;
        proxy.lowerBounds[1] = Integer.MAX_VALUE;
        proxy.upperBounds[0] = Integer.MAX_VALUE;
        proxy.upperBounds[1] = Integer.MAX_VALUE;
        proxy.setNext(this.m_freeProxy);
        this.m_freeProxy = proxyId;
        --this.m_proxyCount;
    }

    public void moveProxy(int proxyId, AABB aabb) {
        BoundValues newValues = (BoundValues)tlNewValues.get();
        BoundValues oldValues = (BoundValues)tlOldValues.get();
        if (proxyId == Integer.MAX_VALUE || 64 <= proxyId) {
            return;
        }
        assert (aabb.isValid()) : "invalid AABB";
        int boundCount = 2 * this.m_proxyCount;
        Proxy proxy = this.m_proxyPool[proxyId];
        this.computeBounds(newValues.lowerValues, newValues.upperValues, aabb);
        int axis = 0;
        while (axis < 2) {
            if (this.m_bounds[axis][proxy.lowerBounds[axis]] != null) {
                oldValues.lowerValues[axis] = this.m_bounds[axis][proxy.lowerBounds[axis]].value;
            }
            if (this.m_bounds[axis][proxy.lowerBounds[axis]] != null) {
                oldValues.upperValues[axis] = this.m_bounds[axis][proxy.upperBounds[axis]].value;
            }
            ++axis;
        }
        axis = 0;
        while (axis < 2) {
            Proxy nextProxy;
            int nextProxyId;
            Bound nextBound;
            Proxy prevProxy;
            int prevProxyId;
            Bound prevBound;
            Bound bound;
            int index;
            Bound[] bounds = this.m_bounds[axis];
            int lowerIndex = proxy.lowerBounds[axis];
            int upperIndex = proxy.upperBounds[axis];
            int lowerValue = newValues.lowerValues[axis];
            int upperValue = newValues.upperValues[axis];
            int deltaLower = bounds[lowerIndex] == null ? 0 : lowerValue - bounds[lowerIndex].value;
            int deltaUpper = bounds[upperIndex] == null ? 0 : upperValue - bounds[upperIndex].value;
            bounds[lowerIndex].setValueInternal(lowerValue);
            bounds[upperIndex].setValueInternal(upperValue);
            if (deltaLower < 0) {
                index = lowerIndex;
                while (index > 0 && lowerValue < bounds[index - 1].value) {
                    bound = bounds[index];
                    prevBound = bounds[index - 1];
                    if (bound != null && prevBound != null) {
                        prevProxyId = prevBound.proxyId;
                        prevProxy = this.m_proxyPool[prevBound.proxyId];
                        ++prevBound.stabbingCount;
                        if (prevBound.isUpper()) {
                            if (this.testOverlap(newValues, prevProxy)) {
                                this.m_pairManager.addBufferedPair(proxyId, prevProxyId);
                            }
                            int n = axis;
                            prevProxy.upperBounds[n] = prevProxy.upperBounds[n] + 1;
                            ++bound.stabbingCount;
                        } else {
                            int n = axis;
                            prevProxy.lowerBounds[n] = prevProxy.lowerBounds[n] + 1;
                            --bound.stabbingCount;
                        }
                        int n = axis;
                        proxy.lowerBounds[n] = proxy.lowerBounds[n] - 1;
                        bound.swap(prevBound);
                    }
                    --index;
                }
            }
            if (deltaUpper > 0) {
                index = upperIndex;
                while (index < boundCount - 1 && bounds[index + 1].value <= upperValue) {
                    bound = bounds[index];
                    nextBound = bounds[index + 1];
                    if (bound != null && nextBound != null) {
                        nextProxyId = nextBound.proxyId;
                        nextProxy = this.m_proxyPool[nextProxyId];
                        ++nextBound.stabbingCount;
                        if (nextBound.isLower()) {
                            if (this.testOverlap(newValues, nextProxy)) {
                                this.m_pairManager.addBufferedPair(proxyId, nextProxyId);
                            }
                            int n = axis;
                            nextProxy.lowerBounds[n] = nextProxy.lowerBounds[n] - 1;
                            ++bound.stabbingCount;
                        } else {
                            int n = axis;
                            nextProxy.upperBounds[n] = nextProxy.upperBounds[n] - 1;
                            --bound.stabbingCount;
                        }
                        int n = axis;
                        proxy.upperBounds[n] = proxy.upperBounds[n] + 1;
                        bound.swap(nextBound);
                    }
                    ++index;
                }
            }
            if (deltaLower > 0) {
                index = lowerIndex;
                while (index < boundCount - 1 && bounds[index + 1].value <= lowerValue) {
                    bound = bounds[index];
                    nextBound = bounds[index + 1];
                    if (bound != null && nextBound != null) {
                        nextProxyId = nextBound.proxyId;
                        nextProxy = this.m_proxyPool[nextProxyId];
                        --nextBound.stabbingCount;
                        if (nextBound.isUpper()) {
                            if (this.testOverlap(oldValues, nextProxy)) {
                                this.m_pairManager.removeBufferedPair(proxyId, nextProxyId);
                            }
                            int n = axis;
                            nextProxy.upperBounds[n] = nextProxy.upperBounds[n] - 1;
                            --bound.stabbingCount;
                        } else {
                            int n = axis;
                            nextProxy.lowerBounds[n] = nextProxy.lowerBounds[n] - 1;
                            ++bound.stabbingCount;
                        }
                        int n = axis;
                        proxy.lowerBounds[n] = proxy.lowerBounds[n] + 1;
                        bound.swap(nextBound);
                    }
                    ++index;
                }
            }
            if (deltaUpper < 0) {
                index = upperIndex;
                while (index > 0 && upperValue < bounds[index - 1].value) {
                    bound = bounds[index];
                    prevBound = bounds[index - 1];
                    if (bound != null && prevBound != null) {
                        prevProxyId = prevBound.proxyId;
                        prevProxy = this.m_proxyPool[prevProxyId];
                        --prevBound.stabbingCount;
                        if (prevBound.isLower()) {
                            if (this.testOverlap(oldValues, prevProxy)) {
                                this.m_pairManager.removeBufferedPair(proxyId, prevProxyId);
                            }
                            int n = axis;
                            prevProxy.lowerBounds[n] = prevProxy.lowerBounds[n] + 1;
                            --bound.stabbingCount;
                        } else {
                            int n = axis;
                            prevProxy.upperBounds[n] = prevProxy.upperBounds[n] + 1;
                            ++bound.stabbingCount;
                        }
                        int n = axis;
                        proxy.upperBounds[n] = proxy.upperBounds[n] - 1;
                        bound.swap(prevBound);
                    }
                    --index;
                }
            }
            ++axis;
        }
    }

    public void commit() {
        this.m_pairManager.commit();
    }

    public Object[] query(AABB aabb, int maxCount) {
        Integer[] lowerValues = (Integer[])tlUpperValues.get(2);
        Integer[] upperValues = (Integer[])tlLowerValues.get(2);
        this.computeBounds(lowerValues, upperValues, aabb);
        Integer[] indexes = (Integer[])tlIndexes.get(2);
        this.query(indexes, lowerValues[0], upperValues[0], this.m_bounds[0], 2 * this.m_proxyCount, 0);
        this.query(indexes, lowerValues[1], upperValues[1], this.m_bounds[1], 2 * this.m_proxyCount, 1);
        assert (this.m_queryResultCount < 64);
        Object[] results = new Object[maxCount];
        int count = 0;
        int i = 0;
        while (i < this.m_queryResultCount && count < maxCount) {
            assert (this.m_queryResults[i] < 64);
            Proxy proxy = this.m_proxyPool[this.m_queryResults[i]];
            proxy.isValid();
            results[i] = proxy.userData;
            ++i;
            ++count;
        }
        Object[] copy = new Object[count];
        System.arraycopy(results, 0, copy, 0, count);
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        return copy;
    }

    public void validate() {
        int axis = 0;
        while (axis < 2) {
            Bound[] bounds = this.m_bounds[axis];
            int boundCount = 2 * this.m_proxyCount;
            int stabbingCount = 0;
            int i = 0;
            while (i < boundCount) {
                Bound bound = bounds[i];
                assert (i == 0 || bounds[i - 1].value <= bound.value);
                assert (bound.proxyId != Integer.MAX_VALUE);
                assert (this.m_proxyPool[bound.proxyId].isValid());
                if (bound.isLower()) {
                    assert (this.m_proxyPool[bound.proxyId].lowerBounds[axis] == i) : String.valueOf(this.m_proxyPool[bound.proxyId].lowerBounds[axis]) + " not " + i;
                    ++stabbingCount;
                } else {
                    assert (this.m_proxyPool[bound.proxyId].upperBounds[axis] == i);
                    --stabbingCount;
                }
                assert (bound.stabbingCount == stabbingCount);
                ++i;
            }
            ++axis;
        }
    }

    private void computeBounds(Integer[] lowerValues, Integer[] upperValues, AABB aabb) {
        assert (aabb.upperBound.x >= aabb.lowerBound.x);
        assert (aabb.upperBound.y >= aabb.lowerBound.y);
        float bx = aabb.lowerBound.x < this.m_worldAABB.upperBound.x ? aabb.lowerBound.x : this.m_worldAABB.upperBound.x;
        float by = aabb.lowerBound.y < this.m_worldAABB.upperBound.y ? aabb.lowerBound.y : this.m_worldAABB.upperBound.y;
        float minVertexX = this.m_worldAABB.lowerBound.x > bx ? this.m_worldAABB.lowerBound.x : bx;
        float minVertexY = this.m_worldAABB.lowerBound.y > by ? this.m_worldAABB.lowerBound.y : by;
        float b1x = aabb.upperBound.x < this.m_worldAABB.upperBound.x ? aabb.upperBound.x : this.m_worldAABB.upperBound.x;
        float b1y = aabb.upperBound.y < this.m_worldAABB.upperBound.y ? aabb.upperBound.y : this.m_worldAABB.upperBound.y;
        float maxVertexX = this.m_worldAABB.lowerBound.x > b1x ? this.m_worldAABB.lowerBound.x : b1x;
        float maxVertexY = this.m_worldAABB.lowerBound.y > b1y ? this.m_worldAABB.lowerBound.y : b1y;
        lowerValues[0] = (int)(this.m_quantizationFactor.x * (minVertexX - this.m_worldAABB.lowerBound.x)) & 0x7FFFFFFE;
        upperValues[0] = (int)(this.m_quantizationFactor.x * (maxVertexX - this.m_worldAABB.lowerBound.x)) | 1;
        lowerValues[1] = (int)(this.m_quantizationFactor.y * (minVertexY - this.m_worldAABB.lowerBound.y)) & 0x7FFFFFFE;
        upperValues[1] = (int)(this.m_quantizationFactor.y * (maxVertexY - this.m_worldAABB.lowerBound.y)) | 1;
        if (upperValues[0] < 0) {
            upperValues[0] = Integer.MAX_VALUE;
        }
        if (upperValues[1] < 0) {
            upperValues[1] = Integer.MAX_VALUE;
        }
    }

    private void query(Integer[] indexes, int lowerValue, int upperValue, Bound[] bounds, int boundCount, int axis) {
        int lowerQuery = BroadPhase.binarySearch(bounds, boundCount, lowerValue);
        int upperQuery = BroadPhase.binarySearch(bounds, boundCount, upperValue);
        int i = lowerQuery;
        while (i < upperQuery) {
            if (bounds[i] != null && bounds[i].isLower()) {
                this.incrementOverlapCount(bounds[i].proxyId);
            }
            ++i;
        }
        if (lowerQuery > 0 && bounds[i = lowerQuery - 1] != null) {
            int s = bounds[i].stabbingCount;
            while (s != 0) {
                assert (i >= 0) : "i = " + i + "; s = " + s;
                if (bounds[i] != null && bounds[i].isLower()) {
                    Proxy proxy = this.m_proxyPool[bounds[i].proxyId];
                    if (lowerQuery <= proxy.upperBounds[axis]) {
                        this.incrementOverlapCount(bounds[i].proxyId);
                        --s;
                    }
                }
                if (--i < 0) break;
            }
        }
        indexes[0] = lowerQuery;
        indexes[1] = upperQuery;
    }

    private void incrementOverlapCount(int proxyId) {
        Proxy proxy = this.m_proxyPool[proxyId];
        if (proxy.timeStamp < this.m_timeStamp) {
            proxy.timeStamp = this.m_timeStamp;
            proxy.overlapCount = 1;
        } else {
            proxy.overlapCount = 2;
            assert (this.m_queryResultCount < 64);
            this.m_queryResults[this.m_queryResultCount] = proxyId;
            ++this.m_queryResultCount;
        }
    }

    private void incrementTimeStamp() {
        if (this.m_timeStamp == Integer.MAX_VALUE) {
            int i = 0;
            while (i < 64) {
                this.m_proxyPool[i].timeStamp = 0;
                ++i;
            }
            this.m_timeStamp = 1;
        } else {
            ++this.m_timeStamp;
        }
    }

    static int binarySearch(Bound[] bounds, int count, int value) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            if (bounds[mid].value > value) {
                high = mid - 1;
                continue;
            }
            if (bounds[mid].value < value) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public boolean inRange(AABB aabb) {
        float dy;
        float ax = aabb.lowerBound.x - this.m_worldAABB.upperBound.x;
        float ay = aabb.lowerBound.y - this.m_worldAABB.upperBound.y;
        float bx = this.m_worldAABB.lowerBound.x - aabb.upperBound.x;
        float by = this.m_worldAABB.lowerBound.y - aabb.upperBound.y;
        float dx = MathUtils.max(ax, bx);
        boolean inRange = MathUtils.max(dx, dy = MathUtils.max(ay, by)) < 0.0f;
        return inRange;
    }

    public int querySegment(Segment segment, Object[] userData, int maxCount, SortKeyFunc sortKey) {
        int sy;
        int sx;
        float maxLambda = 1.0f;
        float dx = (segment.p2.x - segment.p1.x) * this.m_quantizationFactor.x;
        float dy = (segment.p2.y - segment.p1.y) * this.m_quantizationFactor.y;
        int n = dx < -1.1920929E-7f ? -1 : (sx = dx > 1.1920929E-7f ? 1 : 0);
        int n2 = dy < -1.1920929E-7f ? -1 : (sy = dy > 1.1920929E-7f ? 1 : 0);
        assert (sx != 0 || sy != 0);
        float p1x = (segment.p1.x - this.m_worldAABB.lowerBound.x) * this.m_quantizationFactor.x;
        float p1y = (segment.p1.y - this.m_worldAABB.lowerBound.y) * this.m_quantizationFactor.y;
        int[] startValues = new int[2];
        int[] startValues2 = new int[2];
        Proxy proxy = null;
        startValues[0] = (int)p1x & 0x7FFFFFFE;
        startValues2[0] = (int)p1x | 1;
        startValues[1] = (int)p1y & 0x7FFFFFFE;
        startValues2[1] = (int)p1y | 1;
        Integer[] results = (Integer[])tlResults.get(2);
        this.query(results, startValues[0], startValues2[0], this.m_bounds[0], 2 * this.m_proxyCount, 0);
        int xIndex = sx >= 0 ? results[1] - 1 : results[0];
        this.query(results, startValues[1], startValues2[1], this.m_bounds[1], 2 * this.m_proxyCount, 1);
        int yIndex = sy >= 0 ? results[1] - 1 : results[0];
        if (sortKey != null) {
            int i = 0;
            while (i < this.m_queryResultCount) {
                this.m_querySortKeys[i] = sortKey.apply(this.m_proxyPool[this.m_queryResults[i]].userData);
                ++i;
            }
            i = 0;
            while (i < this.m_queryResultCount - 1) {
                float a = this.m_querySortKeys[i];
                float b = this.m_querySortKeys[i + 1];
                if (a < 0.0f ? b >= 0.0f : a > b && b >= 0.0f) {
                    this.m_querySortKeys[i + 1] = a;
                    this.m_querySortKeys[i] = b;
                    int tempValue = this.m_queryResults[i + 1];
                    this.m_queryResults[i + 1] = this.m_queryResults[i];
                    this.m_queryResults[i] = tempValue;
                    if (--i != -1) continue;
                    i = 1;
                    continue;
                }
                ++i;
            }
            while (this.m_queryResultCount > 0 && this.m_querySortKeys[this.m_queryResultCount - 1] < 0.0f) {
                --this.m_queryResultCount;
            }
        }
        float xProgress = 0.0f;
        float yProgress = 0.0f;
        if ((xIndex += sx >= 0 ? 1 : -1) >= 0 && xIndex < this.m_proxyCount * 2) {
            if (sx != 0) {
                xProgress = ((float)this.m_bounds[0][xIndex].value - p1x) / dx;
            }
            if ((yIndex += sy >= 0 ? 1 : -1) >= 0 && yIndex < this.m_proxyCount * 2) {
                if (sy != 0) {
                    yProgress = ((float)this.m_bounds[1][yIndex].value - p1y) / dy;
                }
                while (true) {
                    int proxyId;
                    if (sy == 0 || sx != 0 && xProgress < yProgress) {
                        if (xProgress > maxLambda) break;
                        if (sx > 0 ? this.m_bounds[0][xIndex].isLower() : this.m_bounds[0][xIndex].isUpper()) {
                            proxyId = this.m_bounds[0][xIndex].proxyId;
                            proxy = this.m_proxyPool[proxyId];
                            if (sy >= 0) {
                                if (proxy.lowerBounds[1] <= yIndex - 1 && proxy.upperBounds[1] >= yIndex) {
                                    if (sortKey != null) {
                                        this.addProxyResult(proxyId, proxy, maxCount, sortKey);
                                    } else {
                                        this.m_queryResults[this.m_queryResultCount] = proxyId;
                                        ++this.m_queryResultCount;
                                    }
                                }
                            } else if (proxy.lowerBounds[1] <= yIndex && proxy.upperBounds[1] >= yIndex + 1) {
                                if (sortKey != null) {
                                    this.addProxyResult(proxyId, proxy, maxCount, sortKey);
                                } else {
                                    this.m_queryResults[this.m_queryResultCount] = proxyId;
                                    ++this.m_queryResultCount;
                                }
                            }
                        }
                        if (sortKey != null && this.m_queryResultCount == maxCount && this.m_queryResultCount > 0 && xProgress > this.m_querySortKeys[this.m_queryResultCount - 1] || (sx > 0 ? ++xIndex == this.m_proxyCount * 2 : --xIndex < 0)) break;
                        xProgress = ((float)this.m_bounds[0][xIndex].value - p1x) / dx;
                        continue;
                    }
                    if (yProgress > maxLambda) break;
                    if (sy > 0 ? this.m_bounds[1][yIndex].isLower() : this.m_bounds[1][yIndex].isUpper()) {
                        proxyId = this.m_bounds[1][yIndex].proxyId;
                        proxy = this.m_proxyPool[proxyId];
                        if (sx >= 0) {
                            if (proxy.lowerBounds[0] <= xIndex - 1 && proxy.upperBounds[0] >= xIndex) {
                                if (sortKey != null) {
                                    this.addProxyResult(proxyId, proxy, maxCount, sortKey);
                                } else {
                                    this.m_queryResults[this.m_queryResultCount] = proxyId;
                                    ++this.m_queryResultCount;
                                }
                            }
                        } else if (proxy.lowerBounds[0] <= xIndex && proxy.upperBounds[0] >= xIndex + 1) {
                            if (sortKey != null) {
                                this.addProxyResult(proxyId, proxy, maxCount, sortKey);
                            } else {
                                this.m_queryResults[this.m_queryResultCount] = proxyId;
                                ++this.m_queryResultCount;
                            }
                        }
                    }
                    if (sortKey != null && this.m_queryResultCount == maxCount && this.m_queryResultCount > 0 && yProgress > this.m_querySortKeys[this.m_queryResultCount - 1] || (sy > 0 ? ++yIndex == this.m_proxyCount * 2 : --yIndex < 0)) break;
                    yProgress = ((float)this.m_bounds[1][yIndex].value - p1y) / dy;
                }
            }
        }
        int count = 0;
        int i = 0;
        while (i < this.m_queryResultCount && count < maxCount) {
            assert (this.m_queryResults[i] < 64);
            Proxy proxya = this.m_proxyPool[this.m_queryResults[i]];
            assert (proxya.isValid());
            userData[i] = proxya.userData;
            ++i;
            ++count;
        }
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        return count;
    }

    private void addProxyResult(int proxyId, Proxy proxy, int maxCount, SortKeyFunc sortKey) {
        float key = sortKey.apply(proxy.userData);
        if (key < 0.0f) {
            return;
        }
        int i = 0;
        while (i < this.m_queryResultCount && this.m_querySortKeys[i] < key) {
            ++i;
        }
        if (maxCount == this.m_queryResultCount && i == this.m_queryResultCount) {
            return;
        }
        if (maxCount == this.m_queryResultCount) {
            --this.m_queryResultCount;
        }
        int j = this.m_queryResultCount + 1;
        while (j > i) {
            this.m_querySortKeys[j] = this.m_querySortKeys[j - 1];
            this.m_queryResults[j] = this.m_queryResults[j - 1];
            --j;
        }
        this.m_querySortKeys[i] = key;
        this.m_queryResults[i] = proxyId;
        ++this.m_queryResultCount;
    }
}

