/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

public class Bound {
    public int value;
    public int proxyId;
    public int stabbingCount;

    public Bound() {
        this.value = 0;
        this.proxyId = 0;
        this.stabbingCount = 0;
    }

    public Bound(Bound b) {
        this.value = b.value;
        this.proxyId = b.proxyId;
        this.stabbingCount = b.stabbingCount;
    }

    public final void set(Bound b) {
        this.setValueInternal(b.value);
        this.proxyId = b.proxyId;
        this.stabbingCount = b.stabbingCount;
    }

    public final void setValueInternal(int val) {
        this.value = val;
    }

    public final boolean isLower() {
        return (this.value & 1) == 0;
    }

    public final boolean isUpper() {
        return (this.value & 1) == 1;
    }

    public final void swap(Bound other) {
        int value = this.value;
        int proxyId = this.proxyId;
        int stabbingCount = this.stabbingCount;
        this.setValueInternal(other.value);
        this.proxyId = other.proxyId;
        this.stabbingCount = other.stabbingCount;
        other.setValueInternal(value);
        other.proxyId = proxyId;
        other.stabbingCount = stabbingCount;
    }

    public String toString() {
        String ret = "Bound variable:\n";
        ret = String.valueOf(ret) + "value: " + this.value + "\n";
        ret = String.valueOf(ret) + "proxyId: " + this.proxyId + "\n";
        ret = String.valueOf(ret) + "stabbing count: " + this.stabbingCount + "\n";
        return ret;
    }
}

