/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.common.Vec2;

public class AABB {
    public final Vec2 lowerBound;
    public final Vec2 upperBound;

    public AABB() {
        this.lowerBound = new Vec2();
        this.upperBound = new Vec2();
    }

    public AABB(AABB copy) {
        this(copy.lowerBound, copy.upperBound);
    }

    public AABB(Vec2 lowerVertex, Vec2 upperVertex) {
        this.lowerBound = lowerVertex.clone();
        this.upperBound = upperVertex.clone();
    }

    public final AABB set(AABB aabb) {
        this.lowerBound.set(aabb.lowerBound);
        this.upperBound.set(aabb.upperBound);
        return this;
    }

    public final boolean isValid() {
        float dx = this.upperBound.x - this.lowerBound.x;
        float dy = this.upperBound.y - this.lowerBound.y;
        if (!(dx >= 0.0f) || !(dy >= 0.0f)) {
            return false;
        }
        return this.lowerBound.isValid() && this.upperBound.isValid();
    }

    public final boolean testOverlap(AABB box) {
        float d1x = box.lowerBound.x - this.upperBound.x;
        float d1y = box.lowerBound.y - this.upperBound.y;
        float d2x = this.lowerBound.x - box.upperBound.x;
        float d2y = this.lowerBound.y - box.upperBound.y;
        return !(d1x > 0.0f || d1y > 0.0f || d2x > 0.0f) && !(d2y > 0.0f);
    }

    public final String toString() {
        String s = this.lowerBound + " -> " + this.upperBound;
        return s;
    }
}

