/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PApplet;
import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;

public class FPrismaticJoint
extends FJoint {
    protected FBody m_body1;
    protected FBody m_body2;
    protected Vec2 m_anchor;
    protected Vec2 m_axis;
    protected Vec2 m_localAxis1 = new Vec2(0.0f, 1.0f);
    protected float m_force;
    protected float m_torque;
    protected float m_motorForce;
    protected float m_limitForce;
    protected float m_limitPositionImpulse;
    protected float m_maxMotorForce;
    protected Vec2 m_localAnchor1 = new Vec2(0.0f, 0.0f);
    protected Vec2 m_localAnchor2 = new Vec2(0.0f, 0.0f);
    protected float m_referenceAngle = 0.0f;
    protected boolean m_enableLimit = false;
    protected float m_lowerTranslation = 0.0f;
    protected float m_upperTranslation = 0.0f;
    protected boolean m_enableMotor = false;
    protected float m_motorSpeed = 0.0f;
    protected float m_maxMotorTorque = 0.0f;

    protected void updateLocalAnchors() {
        if (this.m_body1.m_body != null) {
            this.m_body1.m_body.getLocalPointToOut(this.m_anchor, this.m_localAnchor1);
        }
        if (this.m_body2.m_body != null) {
            this.m_body2.m_body.getLocalPointToOut(this.m_anchor, this.m_localAnchor2);
        }
    }

    protected void updateLocalAxis() {
        if (this.m_body1.m_body != null) {
            Vec2 axis = new Vec2(this.m_axis);
            this.m_body1.m_body.getLocalVectorToOut(axis, this.m_localAxis1);
        }
    }

    @Override
    protected JointDef getJointDef(FWorld world) {
        PrismaticJointDef md = new PrismaticJointDef();
        md.body1 = this.m_body1.m_body;
        md.body2 = this.m_body2.m_body;
        md.localAnchor1 = this.m_localAnchor1;
        md.localAnchor2 = this.m_localAnchor2;
        md.referenceAngle = this.m_referenceAngle;
        md.lowerTranslation = this.m_lowerTranslation;
        md.upperTranslation = this.m_upperTranslation;
        md.enableMotor = this.m_enableMotor;
        md.enableLimit = this.m_enableLimit;
        md.motorSpeed = this.m_motorSpeed;
        md.maxMotorForce = this.m_maxMotorForce;
        this.updateLocalAnchors();
        md.localAxis1 = this.m_localAxis1;
        this.m_body1.m_body.wakeUp();
        this.m_body2.m_body.wakeUp();
        return md;
    }

    public FPrismaticJoint(FBody body1, FBody body2) {
        this.m_body1 = body1;
        this.m_body2 = body2;
        this.m_anchor = Fisica.screenToWorld(body2.getX(), body2.getY());
        this.updateLocalAnchors();
        this.m_axis = new Vec2(0.0f, 1.0f);
        this.updateLocalAxis();
        this.m_referenceAngle = this.m_body2.getRotation() - this.m_body1.getRotation();
    }

    public void setAxis(float x, float y) {
        float d = PApplet.dist((float)0.0f, (float)0.0f, (float)x, (float)y);
        this.m_axis.set(x / d, y / d);
        this.updateLocalAxis();
    }

    public void setAnchor(float x, float y) {
        this.m_anchor = Fisica.screenToWorld(x, y);
        this.updateLocalAnchors();
    }

    public float getAnchorX() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor1()).x;
        }
        return Fisica.worldToScreen(this.m_anchor.x);
    }

    public float getAnchorY() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor1()).y;
        }
        return Fisica.worldToScreen(this.m_anchor.y);
    }

    public void setLowerTranslation(float translation) {
        if (this.m_joint != null) {
            ((PrismaticJoint)this.m_joint).m_lowerTranslation = Fisica.screenToWorld(translation);
        }
        this.m_lowerTranslation = Fisica.screenToWorld(translation);
    }

    public void setUpperTranslation(float translation) {
        if (this.m_joint != null) {
            ((PrismaticJoint)this.m_joint).m_upperTranslation = Fisica.screenToWorld(translation);
        }
        this.m_upperTranslation = Fisica.screenToWorld(translation);
    }

    public void setEnableLimit(boolean value) {
        if (this.m_joint != null) {
            ((PrismaticJoint)this.m_joint).m_enableLimit = value;
        }
        this.m_enableLimit = value;
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody1().getX(), this.getBody1().getY());
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody2().getX(), this.getBody2().getY());
        applet.rect(this.getAnchorX(), this.getAnchorY(), 10.0f, 10.0f);
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        int lineHalfLength = 150;
        applet.pushStyle();
        applet.noFill();
        applet.stroke(80, 50.0f);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody1().getX(), this.getBody1().getY());
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody2().getX(), this.getBody2().getY());
        applet.pushMatrix();
        applet.translate(this.getBody1().getX(), this.getBody1().getY());
        applet.rotate(this.getBody1().getRotation());
        applet.translate(Fisica.worldToScreen((Vec2)this.m_localAnchor1).x, Fisica.worldToScreen((Vec2)this.m_localAnchor1).y);
        applet.translate(-Fisica.worldToScreen((Vec2)this.m_localAnchor2).x, -Fisica.worldToScreen((Vec2)this.m_localAnchor2).y);
        applet.rotate(PApplet.atan2((float)this.m_axis.y, (float)this.m_axis.x));
        applet.line((float)(-lineHalfLength), 0.0f, (float)lineHalfLength, 0.0f);
        applet.beginShape();
        applet.vertex((float)(lineHalfLength - 4), -4.0f);
        applet.vertex((float)lineHalfLength, 0.0f);
        applet.vertex((float)(lineHalfLength - 4), 4.0f);
        applet.endShape();
        applet.beginShape();
        applet.vertex((float)(-lineHalfLength + 4), -4.0f);
        applet.vertex((float)(-lineHalfLength), 0.0f);
        applet.vertex((float)(-lineHalfLength + 4), 4.0f);
        applet.endShape();
        applet.popStyle();
        if (this.m_enableLimit) {
            applet.rectMode(1);
            applet.rect(Fisica.worldToScreen(this.m_lowerTranslation), -4.0f, Fisica.worldToScreen(this.m_upperTranslation), 4.0f);
        }
        applet.popMatrix();
        applet.pushStyle();
        applet.noStroke();
        applet.ellipse(this.getAnchorX(), this.getAnchorY(), 5.0f, 5.0f);
        applet.ellipse(this.getBody1().getX(), this.getBody1().getY(), 5.0f, 5.0f);
        applet.ellipse(this.getBody2().getX(), this.getBody2().getY(), 5.0f, 5.0f);
        applet.popStyle();
        this.postDrawDebug(applet);
    }
}

