/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.Fisica;
import java.util.ArrayList;
import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.util.nonconvex.Polygon;

public class FPoly
extends FBody {
    protected Polygon m_polygon;
    protected boolean m_closed = false;
    protected ArrayList m_vertices = new ArrayList();

    public void vertex(float x, float y) {
        this.m_vertices.add(Fisica.screenToWorld(x, y));
    }

    @Override
    protected void processBody(Body bd, ShapeDef sd) {
        Polygon.decomposeConvexAndAddTo((Polygon)this.m_polygon, (Body)bd, (PolygonDef)((PolygonDef)sd));
    }

    @Override
    protected ShapeDef getShapeDef() {
        PolygonDef pd = new PolygonDef();
        this.m_vertices.add(new Vec2((Vec2)this.m_vertices.get(this.m_vertices.size() - 1)));
        this.m_closed = true;
        Vec2[] vertices = new Vec2[this.m_vertices.size()];
        this.m_vertices.toArray(vertices);
        this.m_polygon = new Polygon(vertices);
        pd.density = this.m_density;
        pd.friction = this.m_friction;
        pd.restitution = this.m_restitution;
        pd.isSensor = this.m_sensor;
        return pd;
    }

    @Override
    protected ShapeDef getTransformedShapeDef() {
        PolygonDef pd = (PolygonDef)this.getShapeDef();
        XForm xf = new XForm();
        xf.R.set(-this.m_angle);
        xf.position = Mat22.mul((Mat22)xf.R, (Vec2)this.m_position.negate());
        for (int i = 0; i < pd.vertices.size(); ++i) {
            Vec2 ver = (Vec2)pd.vertices.get(i);
            XForm.mulTransToOut((XForm)xf, (Vec2)ver, (Vec2)ver);
        }
        return pd;
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        if (this.m_image != null) {
            this.drawImage(applet);
        } else {
            applet.beginShape();
            for (int i = 0; i < this.m_vertices.size(); ++i) {
                Vec2 v = Fisica.worldToScreen((Vec2)this.m_vertices.get(i));
                applet.vertex(v.x, v.y);
            }
            if (this.m_closed) {
                applet.endShape(2);
            } else {
                applet.endShape();
            }
        }
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        Body b = this.getBox2dBody();
        if (b != null) {
            applet.pushStyle();
            applet.stroke(120, 100.0f);
            applet.fill(120, 30.0f);
            for (Shape ss = b.getShapeList(); ss != null; ss = ss.getNext()) {
                PolygonShape ps = (PolygonShape)ss;
                Vec2[] vecs = ps.getVertices();
                applet.beginShape();
                for (int j = 0; j < ps.getVertexCount(); ++j) {
                    Vec2 v = Fisica.worldToScreen(vecs[j]);
                    applet.vertex(v.x, v.y);
                }
                applet.endShape(2);
                Vec2 c = Fisica.worldToScreen(ps.getCentroid());
                applet.ellipse(c.x, c.y, 2.0f, 2.0f);
            }
            applet.popStyle();
        }
        applet.beginShape();
        for (int i = 0; i < this.m_vertices.size(); ++i) {
            Vec2 v = Fisica.worldToScreen((Vec2)this.m_vertices.get(i));
            applet.vertex(v.x, v.y);
        }
        if (this.m_closed) {
            applet.endShape(2);
        } else {
            applet.endShape();
        }
        this.postDrawDebug(applet);
    }
}

