/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;

public class FMouseJoint
extends FJoint {
    protected FBody m_fbody;
    protected Vec2 m_anchor;
    protected Vec2 m_target;
    protected float m_damping = 0.9f;
    protected float m_frequency = 20.0f;

    @Override
    protected JointDef getJointDef(FWorld world) {
        Body body = this.m_fbody.m_body;
        MouseJointDef md = new MouseJointDef();
        md.body1 = this.m_world.getGroundBody();
        md.body2 = body;
        md.target.set(this.m_anchor);
        md.maxForce = 10000.0f * body.m_mass;
        md.frequencyHz = this.m_frequency;
        md.dampingRatio = this.m_damping;
        body.wakeUp();
        return md;
    }

    public FMouseJoint(FBody body, float x, float y) {
        this.m_fbody = body;
        this.m_target = Fisica.screenToWorld(x, y);
        this.m_anchor = Fisica.screenToWorld(x, y);
    }

    public void setDamping(float damping) {
        this.m_damping = damping;
    }

    public void setFrequency(float frequency) {
        this.m_frequency = frequency;
    }

    public void setTarget(float x, float y) {
        if (this.m_joint != null) {
            ((MouseJoint)this.m_joint).setTarget(Fisica.screenToWorld(x, y));
        }
        this.m_target = Fisica.screenToWorld(x, y);
    }

    public float getTargetX() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)((MouseJoint)this.m_joint).m_target).x;
        }
        return Fisica.worldToScreen((Vec2)this.m_target).x;
    }

    public float getTargetY() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)((MouseJoint)this.m_joint).m_target).y;
        }
        return Fisica.worldToScreen((Vec2)this.m_target).y;
    }

    public void setGrabbedBodyAndTarget(FBody body, float x, float y) {
        if (this.m_joint != null) {
            this.m_joint.m_body2 = body.m_body;
            ((MouseJoint)this.m_joint).m_target.set(Fisica.screenToWorld(x, y));
            ((MouseJoint)this.m_joint).getAnchor2().set(Fisica.screenToWorld(x), Fisica.screenToWorld(y));
        }
        this.m_fbody = body;
        this.m_target = Fisica.screenToWorld(x, y);
        this.m_anchor = Fisica.screenToWorld(x, y);
    }

    public void releaseGrabbedBody() {
        if (this.m_joint != null) {
            this.m_joint.m_body2 = null;
            ((MouseJoint)this.m_joint).m_target.set(0.0f, 0.0f);
        }
        this.m_fbody = null;
        this.m_target = null;
    }

    public FBody getGrabbedBody() {
        if (this.m_joint != null) {
            return (FBody)this.m_joint.m_body2.getUserData();
        }
        return this.m_fbody;
    }

    public void setAnchor(float x, float y) {
        if (this.m_joint != null) {
            ((MouseJoint)this.m_joint).getAnchor2().set(Fisica.screenToWorld(x), Fisica.screenToWorld(y));
        }
        this.m_anchor = Fisica.screenToWorld(x, y);
    }

    public float getAnchorX() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).x;
        }
        return Fisica.worldToScreen(this.m_anchor.x);
    }

    public float getAnchorY() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).y;
        }
        return Fisica.worldToScreen(this.m_anchor.y);
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getTargetX(), this.getTargetY());
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getTargetX(), this.getTargetY());
        applet.ellipse(this.getAnchorX(), this.getAnchorY(), 5.0f, 5.0f);
        applet.ellipse(this.getTargetX(), this.getTargetY(), 10.0f, 10.0f);
        this.postDrawDebug(applet);
    }
}

