/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class FGearJoint
extends FJoint {
    protected FJoint m_joint1;
    protected FJoint m_joint2;
    protected float m_ratio = 1.0f;
    protected float m_worldRatio = 1.0f;

    @Override
    protected JointDef getJointDef(FWorld world) {
        GearJointDef md = new GearJointDef();
        md.joint1 = this.m_joint1.m_joint;
        md.joint2 = this.m_joint2.m_joint;
        md.ratio = this.m_worldRatio;
        return md;
    }

    protected void updateRatio() {
        this.m_worldRatio = this.m_ratio;
        if (this.m_joint1.m_joint.getType() == JointType.PRISMATIC_JOINT) {
            this.m_worldRatio = Fisica.screenToWorld(this.m_worldRatio);
        }
        if (this.m_joint2.m_joint.getType() == JointType.PRISMATIC_JOINT) {
            this.m_worldRatio = 1.0f / Fisica.screenToWorld(1.0f / this.m_worldRatio);
        }
        if (this.m_joint != null) {
            ((GearJoint)this.m_joint).m_ratio = this.m_worldRatio;
        }
    }

    public FGearJoint(FJoint joint1, FJoint joint2) {
        this.m_joint1 = joint1;
        this.m_joint2 = joint2;
        this.updateRatio();
    }

    public void setRatio(float ratio) {
        this.m_ratio = ratio;
        this.updateRatio();
    }

    @Override
    public void draw(PGraphics applet) {
    }
}

