/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import def.processing.core.PImage;
import fisica.Fisica;

public abstract class FDrawable {
    protected boolean m_drawable = true;
    protected boolean m_fill = true;
    protected int m_fillColor = -1;
    protected boolean m_stroke = true;
    protected int m_strokeColor = -16777216;
    protected float m_strokeWeight = 1.0f;
    protected PImage m_image = null;
    protected float m_imageAlpha = 255.0f;
    protected PImage m_mask = null;

    protected void updateStyle(FDrawable other) {
        this.m_drawable = other.m_drawable;
        this.m_fill = other.m_fill;
        this.m_fillColor = other.m_fillColor;
        this.m_stroke = other.m_stroke;
        this.m_strokeColor = other.m_strokeColor;
        this.m_strokeWeight = other.m_strokeWeight;
        this.m_image = other.m_image;
        this.m_imageAlpha = other.m_imageAlpha;
        this.m_mask = other.m_mask;
    }

    protected void appletStroke(PGraphics applet, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        applet.stroke((float)r, (float)g, (float)b, (float)a);
    }

    protected void appletFill(PGraphics applet, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        applet.fill((float)r, (float)g, (float)b, (float)a);
    }

    protected void appletFillStroke(PGraphics applet) {
        if (this.m_fill) {
            this.appletFill(applet, this.m_fillColor);
        } else {
            applet.noFill();
        }
        if (this.m_stroke) {
            this.appletStroke(applet, this.m_strokeColor);
        } else {
            applet.noStroke();
        }
        applet.strokeWeight(this.m_strokeWeight);
    }

    protected void drawImage(PGraphics applet) {
        applet.tint(255.0f, 255.0f, 255.0f, this.m_imageAlpha);
        applet.image(this.m_image, (float)(0 - this.m_image.width / 2), (float)(0 - this.m_image.height / 2));
        applet.tint(255.0f, 255.0f, 255.0f, 255.0f);
    }

    public void draw(PGraphics graphics) {
    }

    public void drawDebug(PGraphics graphics) {
    }

    public void attachImage(PImage img) {
        this.m_image = img;
    }

    public void dettachImage() {
        this.m_image = null;
    }

    public float getImageAlpha() {
        return this.m_imageAlpha;
    }

    public void setImageAlpha(float alpha) {
        this.m_imageAlpha = alpha;
    }

    public void setDrawable(boolean drawable) {
        this.m_drawable = drawable;
    }

    public boolean isDrawable() {
        return this.m_drawable;
    }

    public int getFillColor() {
        return this.m_fillColor;
    }

    public void setFillColor(int col) {
        this.m_fill = true;
        this.m_fillColor = col;
    }

    public void setNoFill() {
        this.m_fill = false;
    }

    public void setFill(float g) {
        this.setFillColor(Fisica.parent().color(g));
    }

    public void setFill(float g, float a) {
        this.setFillColor(Fisica.parent().color(g, a));
    }

    public void setFill(float r, float g, float b) {
        this.setFillColor(Fisica.parent().color(r, g, b));
    }

    public void setFill(float r, float g, float b, float a) {
        this.setFillColor(Fisica.parent().color(r, g, b, a));
    }

    public void setStrokeColor(int col) {
        this.m_stroke = true;
        this.m_strokeColor = col;
    }

    public void setNoStroke() {
        this.m_stroke = false;
    }

    public void setStroke(float g) {
        this.setStrokeColor(Fisica.parent().color(g));
    }

    public void setStroke(float g, float a) {
        this.setStrokeColor(Fisica.parent().color(g, a));
    }

    public void setStroke(float r, float g, float b) {
        this.setStrokeColor(Fisica.parent().color(r, g, b));
    }

    public void setStroke(float r, float g, float b, float a) {
        this.setStrokeColor(Fisica.parent().color(r, g, b, a));
    }

    public void setStrokeWeight(float weight) {
        this.m_strokeWeight = weight;
    }
}

