/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PApplet;
import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.JointDef;

public class FDistanceJoint
extends FJoint {
    protected FBody m_body1;
    protected FBody m_body2;
    protected float m_damping = 0.3f;
    protected float m_frequency = 10.0f;
    protected float m_length;
    protected Vec2 m_anchor1;
    protected Vec2 m_anchor2;

    @Override
    protected JointDef getJointDef(FWorld world) {
        DistanceJointDef md = new DistanceJointDef();
        if (this.m_body1 == null || this.m_body1.m_body == null || this.m_body2 == null || this.m_body2.m_body == null) {
            return null;
        }
        md.body1 = this.m_body1.m_body;
        md.body2 = this.m_body2.m_body;
        md.localAnchor1 = this.m_anchor1.clone();
        md.localAnchor2 = this.m_anchor2.clone();
        md.length = Fisica.screenToWorld(this.m_length);
        md.frequencyHz = this.m_frequency;
        md.dampingRatio = this.m_damping;
        this.m_body1.m_body.wakeUp();
        this.m_body2.m_body.wakeUp();
        return md;
    }

    public FDistanceJoint(FBody body1, FBody body2) {
        this.m_body1 = body1;
        this.m_body2 = body2;
        this.m_anchor1 = new Vec2(0.0f, 0.0f);
        this.m_anchor2 = new Vec2(0.0f, 0.0f);
        this.calculateLength();
    }

    public void setDamping(float damping) {
        if (this.m_joint != null) {
            ((DistanceJoint)this.m_joint).m_dampingRatio = damping;
        }
        this.m_damping = damping;
    }

    public void setFrequency(float frequency) {
        if (this.m_joint != null) {
            ((DistanceJoint)this.m_joint).m_frequencyHz = frequency;
        }
        this.m_frequency = frequency;
    }

    public void calculateLength() {
        float lengthX = this.m_body1.getX() + this.getAnchor1X() - (this.m_body2.getX() + this.getAnchor2X());
        float lengthY = this.m_body1.getY() + this.getAnchor1Y() - (this.m_body2.getY() + this.getAnchor2Y());
        this.setLength((float)Math.sqrt(lengthX * lengthX + lengthY * lengthY));
    }

    public void setLength(float length) {
        if (this.m_joint != null) {
            ((DistanceJoint)this.m_joint).m_length = Fisica.screenToWorld(length);
        }
        this.m_length = length;
    }

    public void setAnchor2(float x, float y) {
        if (this.m_joint != null) {
            ((DistanceJoint)this.m_joint).getAnchor2().set(Fisica.screenToWorld(x), Fisica.screenToWorld(y));
        }
        this.m_anchor2 = Fisica.screenToWorld(x, y);
    }

    public void setAnchor1(float x, float y) {
        if (this.m_joint != null) {
            ((DistanceJoint)this.m_joint).getAnchor1().set(Fisica.screenToWorld(x), Fisica.screenToWorld(y));
        }
        this.m_anchor1 = Fisica.screenToWorld(x, y);
    }

    public float getAnchor1X() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor1()).x;
        }
        return Fisica.worldToScreen(this.m_anchor1.x);
    }

    public float getAnchor1Y() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor1()).y;
        }
        return Fisica.worldToScreen(this.m_anchor1.y);
    }

    public float getAnchor2X() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).x;
        }
        return Fisica.worldToScreen(this.m_anchor2.x);
    }

    public float getAnchor2Y() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).y;
        }
        return Fisica.worldToScreen(this.m_anchor2.y);
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        applet.ellipse(this.getAnchor1X(), this.getAnchor1Y(), 5.0f, 5.0f);
        applet.line(this.getAnchor1X(), this.getAnchor1Y(), this.getAnchor2X(), this.getAnchor2Y());
        applet.ellipse(this.getAnchor2X(), this.getAnchor2Y(), 5.0f, 5.0f);
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        int numSpins = (int)((this.m_length - 20.0f) / 6.0f) / 2 * 2 + 1;
        if (numSpins <= 0) {
            applet.line(this.getAnchor1X(), this.getAnchor1Y(), this.getAnchor2X(), this.getAnchor2Y());
        } else {
            float x;
            applet.pushMatrix();
            applet.translate(this.getAnchor1X(), this.getAnchor1Y());
            float ang = PApplet.atan2((float)(this.getAnchor2Y() - this.getAnchor1Y()), (float)(this.getAnchor2X() - this.getAnchor1X()));
            float dist = PApplet.dist((float)this.getAnchor1X(), (float)this.getAnchor1Y(), (float)this.getAnchor2X(), (float)this.getAnchor2Y());
            applet.rotate(ang);
            if (this.m_length > 0.0f) {
                applet.rect(dist / 2.0f, 0.0f, this.m_length, 12.0f);
            }
            applet.pushStyle();
            applet.noFill();
            applet.beginShape();
            applet.vertex(0.0f, 0.0f);
            applet.vertex(10.0f, 0.0f);
            for (int i = 0; i < numSpins; ++i) {
                x = PApplet.map((float)(i + 1), (float)0.0f, (float)(numSpins + 1), (float)10.0f, (float)(dist - 10.0f));
                float y = (i % 2 * 2 - 1) * 4;
                applet.vertex(x, y);
            }
            x = PApplet.map((float)(numSpins + 1), (float)0.0f, (float)(numSpins + 1), (float)10.0f, (float)(dist - 10.0f));
            applet.vertex(x, 0.0f);
            applet.vertex(dist, 0.0f);
            applet.endShape();
            applet.popStyle();
            applet.popMatrix();
        }
        applet.pushStyle();
        applet.noStroke();
        applet.ellipse(this.getAnchor1X(), this.getAnchor1Y(), 5.0f, 5.0f);
        applet.ellipse(this.getAnchor2X(), this.getAnchor2Y(), 5.0f, 5.0f);
        applet.popStyle();
        this.postDrawDebug(applet);
    }
}

