/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import fisica.FBody;
import fisica.FContactID;
import fisica.Fisica;
import org.jbox2d.collision.ContactID;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactResult;

public class FContactResult {
    protected Vec2 m_position;
    protected Vec2 m_normal;
    protected FBody m_body1;
    protected FBody m_body2;
    protected float m_normalImpulse;
    protected float m_tangentImpulse;
    protected FContactID m_id;

    protected FContactResult(ContactResult contactResult) {
        this.m_position = new Vec2(contactResult.position);
        this.m_normal = new Vec2(contactResult.normal);
        this.m_body1 = (FBody)contactResult.shape1.getBody().getUserData();
        this.m_body2 = (FBody)contactResult.shape2.getBody().getUserData();
        this.m_normalImpulse = contactResult.normalImpulse;
        this.m_tangentImpulse = contactResult.tangentImpulse;
        this.m_id = new FContactID(new ContactID(contactResult.id), this.m_body1, this.m_body2);
    }

    public FBody getBody1() {
        return this.m_body1;
    }

    public FBody getBody2() {
        return this.m_body2;
    }

    public float getX() {
        return Fisica.worldToScreen((Vec2)this.m_position).x;
    }

    public float getY() {
        return Fisica.worldToScreen((Vec2)this.m_position).y;
    }

    public float getNormalX() {
        return Fisica.worldToScreen((Vec2)this.m_normal).x;
    }

    public float getNormalY() {
        return Fisica.worldToScreen((Vec2)this.m_normal).y;
    }

    public float getNormalImpulse() {
        return Fisica.worldToScreen(this.m_normalImpulse);
    }

    public float getTangentImpulse() {
        return Fisica.worldToScreen(this.m_tangentImpulse);
    }

    public FContactID getId() {
        return this.m_id;
    }
}

