/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import fisica.FBody;
import fisica.FContactID;
import fisica.Fisica;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactPoint;

public class FContact {
    protected FBody m_body1;
    protected FBody m_body2;
    protected Vec2 m_position;
    protected Vec2 m_velocity;
    protected Vec2 m_normal;
    protected float m_separation;
    protected float m_friction;
    protected float m_restitution;
    protected FContactID m_id;

    protected FContact(ContactPoint contactPoint) {
        this.m_position = new Vec2(contactPoint.position);
        this.m_velocity = new Vec2(contactPoint.velocity);
        this.m_normal = new Vec2(contactPoint.normal);
        this.m_separation = contactPoint.separation;
        this.m_friction = contactPoint.friction;
        this.m_restitution = contactPoint.restitution;
        Shape s1 = contactPoint.shape1;
        Shape s2 = contactPoint.shape2;
        this.m_body1 = s1.m_userData != null ? (FBody)s1.m_userData : (FBody)s1.getBody().getUserData();
        this.m_body2 = s2.m_userData != null ? (FBody)s2.m_userData : (FBody)s2.getBody().getUserData();
        this.m_id = new FContactID(new ContactID(contactPoint.id), this.m_body1, this.m_body2);
    }

    public FBody getBody1() {
        return this.m_body1;
    }

    public FBody getBody2() {
        return this.m_body2;
    }

    public float getX() {
        return Fisica.worldToScreen((Vec2)this.m_position).x;
    }

    public float getY() {
        return Fisica.worldToScreen((Vec2)this.m_position).y;
    }

    public float getVelocityX() {
        return Fisica.worldToScreen((Vec2)this.m_velocity).x;
    }

    public float getVelocityY() {
        return Fisica.worldToScreen((Vec2)this.m_velocity).y;
    }

    public float getNormalX() {
        return Fisica.worldToScreen((Vec2)this.m_normal).x;
    }

    public float getNormalY() {
        return Fisica.worldToScreen((Vec2)this.m_normal).y;
    }

    public float getSeparation() {
        return Fisica.worldToScreen(this.m_separation);
    }

    public float getFriction() {
        return this.m_friction;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public FContactID getId() {
        return this.m_id;
    }

    public boolean contains(String n1, String n2) {
        if (this.getBody1() == null || this.getBody2() == null) {
            return false;
        }
        if (this.getBody1().getName() == null || this.getBody2().getName() == null) {
            return false;
        }
        return this.getBody1().getName().equals(n1) && this.getBody2().getName().equals(n2) || this.getBody1().getName().equals(n2) && this.getBody2().getName().equals(n1);
    }

    public boolean contains(FBody n1, FBody n2) {
        if (this.getBody1() == null || this.getBody2() == null) {
            return false;
        }
        return this.getBody1() == n1 && this.getBody2() == n2 || this.getBody1() == n2 && this.getBody2() == n1;
    }

    public boolean contains(String n1) {
        if (this.getBody1() != null && this.getBody1().getName() != null && this.getBody1().getName().equals(n1)) {
            return true;
        }
        return this.getBody2() != null && this.getBody2().getName() != null && this.getBody2().getName().equals(n1);
    }

    public boolean contains(FBody n1) {
        if (this.getBody1() != null && this.getBody1() == n1) {
            return true;
        }
        return this.getBody2() != null && this.getBody2() == n1;
    }
}

