/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import def.processing.core.PVector;
import fisica.FBody;
import fisica.FJoint;
import fisica.FWorld;
import java.util.ArrayList;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.JointDef;

public class FConstantVolumeJoint
extends FJoint {
    protected ArrayList m_bodies = new ArrayList();
    protected float m_damping = 0.0f;
    protected float m_frequency = 0.0f;

    @Override
    protected JointDef getJointDef(FWorld world) {
        ConstantVolumeJointDef md = new ConstantVolumeJointDef();
        md.frequencyHz = this.m_frequency;
        md.dampingRatio = this.m_damping;
        for (int i = 0; i < this.m_bodies.size(); ++i) {
            Body b = ((FBody)this.m_bodies.get((int)i)).m_body;
            if (b == null) continue;
            md.addBody(b);
        }
        return md;
    }

    public void addBody(FBody b) {
        this.m_bodies.add(b);
    }

    public ArrayList getBodies() {
        return this.m_bodies;
    }

    public void setDamping(float damping) {
        this.m_damping = damping;
    }

    public void setFrequency(float frequency) {
        this.m_frequency = frequency;
    }

    public PVector getCentroid() {
        int i;
        PVector centroid = new PVector(0.0f, 0.0f);
        float signedArea = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float a = 0.0f;
        for (i = 0; i < this.m_bodies.size() - 1; ++i) {
            x0 = ((FBody)this.m_bodies.get(i)).getX();
            y0 = ((FBody)this.m_bodies.get(i)).getY();
            x1 = ((FBody)this.m_bodies.get(i + 1)).getX();
            y1 = ((FBody)this.m_bodies.get(i + 1)).getY();
            a = x0 * y1 - x1 * y0;
            signedArea += a;
            centroid.x += (x0 + x1) * a;
            centroid.y += (y0 + y1) * a;
        }
        x0 = ((FBody)this.m_bodies.get(i)).getX();
        y0 = ((FBody)this.m_bodies.get(i)).getY();
        x1 = ((FBody)this.m_bodies.get(0)).getX();
        y1 = ((FBody)this.m_bodies.get(0)).getY();
        a = x0 * y1 - x1 * y0;
        signedArea += a;
        centroid.x += (x0 + x1) * a;
        centroid.y += (y0 + y1) * a;
        signedArea = (float)((double)signedArea * 0.5);
        centroid.x = (float)((double)centroid.x / (6.0 * (double)signedArea));
        centroid.y = (float)((double)centroid.y / (6.0 * (double)signedArea));
        return centroid;
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        if (this.m_image != null) {
            applet.pushMatrix();
            PVector c = this.getCentroid();
            applet.translate(c.x, c.y);
            this.drawImage(applet);
            applet.popMatrix();
        } else if (this.m_bodies.size() > 0) {
            applet.beginShape();
            for (int i = 0; i < this.m_bodies.size(); ++i) {
                applet.vertex(((FBody)this.m_bodies.get(i)).getX(), ((FBody)this.m_bodies.get(i)).getY());
            }
            applet.endShape(2);
        }
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        if (this.m_bodies.size() > 0) {
            int i;
            applet.beginShape();
            for (i = 0; i < this.m_bodies.size(); ++i) {
                applet.vertex(((FBody)this.m_bodies.get(i)).getX(), ((FBody)this.m_bodies.get(i)).getY());
            }
            applet.endShape(2);
            for (i = 0; i < this.m_bodies.size(); ++i) {
                applet.ellipse(((FBody)this.m_bodies.get(i)).getX(), ((FBody)this.m_bodies.get(i)).getY(), 5.0f, 5.0f);
            }
        }
        this.postDrawDebug(applet);
    }
}

