/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.Fisica;
import org.jbox2d.collision.shapes.CircleDef;
import org.jbox2d.collision.shapes.ShapeDef;

public class FCircle
extends FBody {
    protected float m_size;

    @Override
    protected ShapeDef getShapeDef() {
        CircleDef pd = new CircleDef();
        pd.radius = this.m_size / 2.0f;
        pd.density = this.m_density;
        pd.friction = this.m_friction;
        pd.restitution = this.m_restitution;
        pd.isSensor = this.m_sensor;
        return pd;
    }

    @Override
    protected ShapeDef getTransformedShapeDef() {
        CircleDef pd = (CircleDef)this.getShapeDef();
        pd.localPosition.set(this.m_position);
        return pd;
    }

    public FCircle(float size) {
        this.m_size = Fisica.screenToWorld(size);
    }

    public float getSize() {
        return Fisica.worldToScreen(this.m_size);
    }

    public void setSize(float size) {
        this.m_size = Fisica.screenToWorld(size);
        this.recreateInWorld();
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        if (this.m_image != null) {
            this.drawImage(applet);
        } else {
            applet.ellipse(0.0f, 0.0f, this.getSize(), this.getSize());
        }
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        applet.ellipse(0.0f, 0.0f, this.getSize(), this.getSize());
        applet.line(0.0f, 0.0f, this.getSize() / 2.0f, 0.0f);
        this.postDrawDebug(applet);
    }
}

