/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.test.jspec;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.javalite.common.Inflector;
import org.javalite.test.jspec.TestException;

public class Expectation<T> {
    private final T actual;

    public Expectation(T actual) {
        this.actual = actual;
    }

    public void shouldEqual(T expected) {
        this.shouldBeEqual(expected);
    }

    public void shouldBeEqual(T expected) {
        this.checkNull();
        if (this.actual == null) {
            if (expected != null) {
                throw this.newShouldBeEqualException(expected);
            }
        } else {
            if (expected == null) {
                throw this.newShouldBeEqualException(null);
            }
            if (this.actual instanceof Number && expected instanceof Number ? new BigDecimal(this.actual.toString()).compareTo(new BigDecimal(expected.toString())) != 0 : !this.actual.equals(expected)) {
                throw this.newShouldBeEqualException(expected);
            }
        }
    }

    private TestException newShouldBeEqualException(T expected) {
        StringBuilder sb = new StringBuilder().append("Test object:\n");
        if (this.actual == null) {
            sb.append("null");
        } else {
            sb.append(this.actual.getClass().getName()).append(" == <").append(this.actual).append(">\n");
        }
        sb.append("and expected\n");
        if (expected == null) {
            sb.append("null");
        } else {
            sb.append(expected.getClass().getName()).append(" == <").append(expected).append(">\n");
        }
        sb.append("are not equal, but they should be.");
        return new TestException(sb.toString());
    }

    public void shouldHave(String booleanMethod) {
        this.shouldBe(booleanMethod);
    }

    public void shouldNotHave(String booleanMethod) {
        this.shouldNotBe(booleanMethod);
    }

    public void shouldBe(String booleanMethod) {
        this.invokeBoolean(booleanMethod, Boolean.TRUE);
    }

    public void shouldNotBe(String booleanMethod) {
        this.invokeBoolean(booleanMethod, Boolean.FALSE);
    }

    public void shouldNotBeEqual(T expected) {
        this.checkNull();
        if (this.actual.equals(expected)) {
            throw new TestException("Objects: '" + this.actual + "' and '" + expected + "' are equal, but they should not be");
        }
    }

    public void shouldNotBeNull() {
        if (this.actual == null) {
            throw new TestException("Object is null, while it is not expected");
        }
    }

    public void shouldBeType(Class clazz) {
        this.checkNull();
        if (!clazz.isAssignableFrom(this.actual.getClass())) {
            throw new TestException(this.actual.getClass() + " is not " + clazz);
        }
    }

    public void shouldBeA(Class clazz) {
        this.shouldBeType(clazz);
    }

    public void shouldBeFalse() {
        this.checkNull();
        if (((Boolean)this.actual).booleanValue()) {
            throw new TestException("should not be true, but it is");
        }
    }

    public void shouldBeTrue() {
        this.checkNull();
        if (!((Boolean)this.actual).booleanValue()) {
            throw new TestException("should be true, but it is not");
        }
    }

    public void shouldBeNull() {
        if (this.actual != null) {
            throw new TestException("argument is not null, but it should be");
        }
    }

    public void shouldBeTheSameAs(T expected) {
        this.checkNull();
        if (this.actual != expected) {
            throw new TestException("references are not the same, but they should be");
        }
    }

    public void shouldContain(Object expected) {
        if (!this.contains(expected)) {
            throw new TestException("tested value does not contain expected value: " + expected);
        }
    }

    public void shouldNotContain(Object expected) {
        if (this.contains(expected)) {
            throw new TestException("tested object contains the value: " + expected + ", but it should not");
        }
    }

    private boolean contains(Object expected) {
        this.checkNull();
        if (this.actual instanceof Collection) {
            return ((Collection)this.actual).contains(expected);
        }
        if (this.actual instanceof Map) {
            return ((Map)this.actual).containsKey(expected);
        }
        return this.actual.toString().contains(expected.toString());
    }

    public void shouldNotBeTheSameAs(T expected) {
        this.checkNull();
        if (this.actual == expected) {
            throw new TestException("references are the same, but they should not be");
        }
    }

    private Method booleanMethodNamed(String name) {
        try {
            Method m = this.actual.getClass().getMethod(name, new Class[0]);
            return Boolean.TYPE.equals(m.getReturnType()) || Boolean.class.equals(m.getReturnType()) ? m : null;
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private void invokeBoolean(String booleanMethod, Boolean returnValue) {
        Object result;
        this.checkNull();
        String methodName1 = "is" + Inflector.capitalize(booleanMethod);
        String methodName2 = "has" + Inflector.capitalize(booleanMethod);
        Method m = this.booleanMethodNamed(booleanMethod);
        if (m == null) {
            m = this.booleanMethodNamed(methodName1);
        }
        if (m == null) {
            m = this.booleanMethodNamed(methodName2);
        }
        if (m == null) {
            throw new IllegalArgumentException("failed to find a matching method for class: " + this.actual.getClass() + ", named: " + booleanMethod + ", " + methodName1 + " or " + methodName2);
        }
        try {
            result = m.invoke(this.actual, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!returnValue.equals(result)) {
            throw new TestException("Method: " + m.getName() + " should return " + returnValue + ", but returned " + result);
        }
    }

    private void checkNull() {
        if (this.actual == null) {
            throw new IllegalArgumentException("tested value is null");
        }
    }
}

