/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.associations;

import java.util.Map;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.associations.Association;

public class OneToManyAssociation
extends Association {
    public static final String FK = "FK";
    private String fkName;

    public OneToManyAssociation(Map<String, Object> map) throws ClassNotFoundException {
        super(map);
        this.fkName = (String)map.get(FK);
    }

    public OneToManyAssociation(Class<? extends Model> sourceModelClass, Class<? extends Model> targetModelClass, String fkName) {
        super(sourceModelClass, targetModelClass);
        this.fkName = fkName;
    }

    public String getFkName() {
        return this.fkName;
    }

    public String toString() {
        return this.getSourceClass().getSimpleName() + "  ----------<  " + this.getTargetClass().getSimpleName() + ", type: has-many";
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        OneToManyAssociation otherAss = (OneToManyAssociation)other;
        return otherAss.fkName.equals(this.fkName) && otherAss.getSourceClass().equals(this.getSourceClass()) && otherAss.getTargetClass().equals(this.getTargetClass());
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put(FK, this.fkName);
        return map;
    }
}

