/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelDelegate;

public class ScopeBuilder<T extends Model> {
    private Class<T> modelClass;
    private List<String> scopes;

    public ScopeBuilder(Class<T> modelClass, String[] scopes) {
        this.modelClass = modelClass;
        this.scopes = new ArrayList<String>(Arrays.asList(scopes));
    }

    public <T extends Model> LazyList<T> where(String subquery, Object ... params) {
        StringBuilder query;
        if (subquery.equals("*")) {
            query = new StringBuilder();
        } else {
            query = new StringBuilder(subquery);
            query.append(" AND ");
        }
        for (int i = 0; i < this.scopes.size(); ++i) {
            String scope = this.scopes.get(i);
            if (!ModelDelegate.getScopes(this.modelClass.getName()).containsKey(scope)) {
                throw new DBException(String.format("Scope '%s' is not defined in model '%s'.", scope, this.modelClass.getName()));
            }
            String scopeQuery = ModelDelegate.getScopes(this.modelClass.getName()).get(scope);
            query.append(scopeQuery);
            if (i >= this.scopes.size() - 1) continue;
            query.append(" AND ");
        }
        return ModelDelegate.where(this.modelClass, query.toString(), params);
    }

    public <T extends Model> LazyList<T> all() {
        return this.where("*", new Object[0]);
    }

    public ScopeBuilder<T> scope(String scope) {
        this.scopes.add(scope);
        return this;
    }
}

