/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.logging.ActiveJDBCLogger;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private Properties properties = new Properties();
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static ActiveJDBCLogger activeLogger;

    protected Configuration() {
        this.loadProjectProperties();
        this.loadOverridesFromSystemProperties();
        String loggerClass = this.properties.getProperty(PropertyName.ActiveJdbcLogger.name);
        if (loggerClass != null) {
            try {
                activeLogger = (ActiveJDBCLogger)Class.forName(loggerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new InitException("Failed to initialize a ActiveJDBCLogger. Please, ensure that the property 'activejdbc.logger' points to correct class which extends '" + ActiveJDBCLogger.class.getName() + "' and provides a default constructor.", e);
            }
        }
    }

    private void loadOverridesFromSystemProperties() {
        PropertyName[] names;
        for (PropertyName propertyName : names = PropertyName.values()) {
            String sysProp = System.getProperty(propertyName.name);
            if (sysProp == null) continue;
            this.properties.put(propertyName.name, sysProp);
        }
    }

    private void loadProjectProperties() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/activejdbc.properties");
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
    }

    private Set<String> getEnvironments(Properties props) {
        HashSet<String> environments = new HashSet<String>();
        for (Object k : props.keySet()) {
            String environment = k.toString().split("\\.")[0];
            environments.add(environment);
        }
        return new TreeSet<String>(environments);
    }

    private Properties readPropertyFile(String file) throws IOException {
        String fileName = file.startsWith("/") ? file : "/" + file;
        LOGGER.info("Reading properties from: " + fileName + ". Will try classpath, then file system.");
        return Util.readProperties((String)fileName);
    }

    public boolean collectStatistics() {
        return Convert.toBoolean((Object)this.properties.getProperty(PropertyName.CollectStatistics.name, "false"));
    }

    public boolean collectStatisticsOnHold() {
        return Convert.toBoolean((Object)this.properties.getProperty(PropertyName.CollectStatisticsOnHold.name, "false"));
    }

    public String getCacheManager() {
        return this.properties.getProperty(PropertyName.CacheManager.name);
    }

    public static boolean hasActiveLogger() {
        return activeLogger != null;
    }

    public static ActiveJDBCLogger getActiveLogger() {
        return activeLogger;
    }

    public static enum PropertyName {
        CacheManager("cache.manager"),
        ActiveJdbcLogger("activejdbc.logger"),
        CollectStatistics("collectStatistics"),
        CollectStatisticsOnHold("collectStatisticsOnHold");

        private String name;

        private PropertyName(String name) {
            this.name = name;
        }
    }
}

