/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.associations;

import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.Model;

public class Many2ManyAssociation
extends Association {
    private final String sourceFkName;
    private final String targetFkName;
    private final String join;
    private final String targetPk;

    public Many2ManyAssociation(Class<? extends Model> source, Class<? extends Model> target, String join, String sourceFkName, String targetFkName, String targetPk) {
        super(source, target);
        this.targetFkName = targetFkName;
        this.sourceFkName = sourceFkName;
        this.join = join;
        this.targetPk = targetPk;
    }

    public Many2ManyAssociation(Class<? extends Model> sourceModelClass, Class<? extends Model> targetModelClass, String join, String sourceFkName, String targetFkName) {
        this(sourceModelClass, targetModelClass, join, sourceFkName, targetFkName, "id");
    }

    public String getSourceFkName() {
        return this.sourceFkName;
    }

    public String getTargetFkName() {
        return this.targetFkName;
    }

    public String getJoin() {
        return this.join;
    }

    public String getTargetPk() {
        return this.targetPk;
    }

    public String toString() {
        return this.getSourceClass().getSimpleName() + "  >---------<  " + this.getTargetClass().getSimpleName() + ", type: " + "many-to-many" + ", join: " + this.join;
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        Many2ManyAssociation otherAss = (Many2ManyAssociation)other;
        return otherAss.getSourceClass().equals(this.getSourceClass()) && otherAss.getTargetClass().equals(this.getTargetClass()) && otherAss.getSourceFkName().equalsIgnoreCase(this.getSourceFkName()) && otherAss.getTargetFkName().equalsIgnoreCase(this.getTargetFkName()) && otherAss.getJoin().equalsIgnoreCase(this.getJoin());
    }
}

