/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.CtClass;
import org.javalite.instrumentation.Classes;
import org.javalite.instrumentation.InstrumentationException;
import org.javalite.instrumentation.InstrumentationModelFinder;
import org.javalite.instrumentation.Logger;
import org.javalite.instrumentation.ModelInstrumentation;

public class JavaAgent {
    private static InstrumentationModelFinder modelFinder;
    private static ModelInstrumentation modelInstrumentation;
    private static final Set<ClassLoader> loaders;
    private static Method modelFound;

    private JavaAgent() {
    }

    public static void premain(String args, Instrumentation inst) {
        Logger.debug("You are using dynamic instrumentation...");
        try {
            modelFinder = new InstrumentationModelFinder();
            modelInstrumentation = new ModelInstrumentation();
            modelFound = Classes.ModelFinder.getDeclaredMethod("modelFound", String.class);
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public synchronized byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    CtClass clazz = modelFinder.getClazz(className.replace('/', '.'));
                    if (modelFinder.isModel(clazz)) {
                        if (!loaders.contains(loader) && loader instanceof URLClassLoader) {
                            JavaAgent.scanLoader(loader);
                            loaders.add(loader);
                            List<CtClass> models = modelFinder.getModels();
                            for (CtClass ctClass : models) {
                                modelFound.invoke(null, ctClass.getName());
                            }
                        }
                        byte[] bytecode = modelInstrumentation.instrument(clazz);
                        Logger.debug("Instrumented model: " + clazz.getName());
                        return bytecode;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new InstrumentationException(e);
                }
            }
        });
    }

    private static void scanLoader(ClassLoader loader) throws ClassNotFoundException, IOException, URISyntaxException {
        Logger.debug("Scanning  class loader:  " + loader);
        List<String> toSkipList = Arrays.asList("rt.jar", "activejdbc-", "javalite-common", "mysql-connector", "slf4j", "rt.jar", "jre", "jdk", "springframework", "servlet-api", "activeweb", "junit", "jackson", "jaxen", "dom4j", "guice", "javax", "aopalliance", "commons-logging", "app-config", "freemarker", "commons-fileupload", "hamcrest", "commons-fileupload", "commons-io", "javassist", "ehcache", "xml-apis");
        if (loader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)loader).getURLs()) {
                boolean skip = false;
                for (String name : toSkipList) {
                    if (!url.getPath().contains(name)) continue;
                    skip = true;
                }
                if (skip) continue;
                modelFinder.processURL(url);
            }
        }
    }

    static {
        loaders = new HashSet<ClassLoader>();
    }
}

