/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.sockets.sslengine;

import com.subgraph.orchid.sockets.sslengine.HandshakeCallbackHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLEngineManager {
    private static final Logger logger = Logger.getLogger(SSLEngineManager.class.getName());
    private final SSLEngine engine;
    private final InputStream input;
    private final OutputStream output;
    private final ByteBuffer peerApplicationBuffer;
    private final ByteBuffer peerNetworkBuffer;
    private final ByteBuffer myApplicationBuffer;
    private final ByteBuffer myNetworkBuffer;
    private final HandshakeCallbackHandler handshakeCallback;
    private boolean handshakeStarted = false;

    SSLEngineManager(SSLEngine engine, HandshakeCallbackHandler handshakeCallback, InputStream input, OutputStream output) {
        this.engine = engine;
        this.handshakeCallback = handshakeCallback;
        this.input = input;
        this.output = output;
        SSLSession session = engine.getSession();
        this.peerApplicationBuffer = SSLEngineManager.createApplicationBuffer(session);
        this.peerNetworkBuffer = SSLEngineManager.createPacketBuffer(session);
        this.myApplicationBuffer = SSLEngineManager.createApplicationBuffer(session);
        this.myNetworkBuffer = SSLEngineManager.createPacketBuffer(session);
    }

    private static ByteBuffer createApplicationBuffer(SSLSession session) {
        return SSLEngineManager.createBuffer(session.getApplicationBufferSize());
    }

    private static ByteBuffer createPacketBuffer(SSLSession session) {
        return SSLEngineManager.createBuffer(session.getPacketBufferSize());
    }

    private static ByteBuffer createBuffer(int sz) {
        byte[] array = new byte[sz];
        return ByteBuffer.wrap(array);
    }

    void startHandshake() throws IOException {
        logger.fine("startHandshake()");
        this.handshakeStarted = true;
        this.engine.beginHandshake();
        this.runHandshake();
    }

    ByteBuffer getSendBuffer() {
        return this.myApplicationBuffer;
    }

    ByteBuffer getRecvBuffer() {
        return this.peerApplicationBuffer;
    }

    int write() throws IOException {
        int p;
        logger.fine("write()");
        if (!this.handshakeStarted) {
            this.startHandshake();
        }
        if ((p = this.myApplicationBuffer.position()) == 0) {
            return 0;
        }
        this.myNetworkBuffer.clear();
        this.myApplicationBuffer.flip();
        SSLEngineResult result = this.engine.wrap(this.myApplicationBuffer, this.myNetworkBuffer);
        this.myApplicationBuffer.compact();
        if (logger.isLoggable(Level.FINE)) {
            this.logResult(result);
        }
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                throw new BufferOverflowException();
            }
            case BUFFER_UNDERFLOW: {
                throw new BufferUnderflowException();
            }
            case CLOSED: {
                throw new SSLException("SSLEngine is closed");
            }
            case OK: {
                break;
            }
        }
        this.flush();
        if (this.runHandshake()) {
            this.write();
        }
        return p - this.myApplicationBuffer.position();
    }

    int read() throws IOException {
        logger.fine("read()");
        if (!this.handshakeStarted) {
            this.startHandshake();
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        int n = this.networkReadBuffer(this.peerNetworkBuffer);
        if (n == -1) {
            return -1;
        }
        int p = this.peerApplicationBuffer.position();
        this.peerNetworkBuffer.flip();
        SSLEngineResult result = this.engine.unwrap(this.peerNetworkBuffer, this.peerApplicationBuffer);
        this.peerNetworkBuffer.compact();
        if (logger.isLoggable(Level.FINE)) {
            this.logResult(result);
        }
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                throw new BufferOverflowException();
            }
            case BUFFER_UNDERFLOW: {
                return 0;
            }
            case CLOSED: {
                this.input.close();
                break;
            }
            case OK: {
                break;
            }
        }
        this.runHandshake();
        if (n == -1) {
            this.engine.closeInbound();
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        return this.peerApplicationBuffer.position() - p;
    }

    void close() throws IOException {
        try {
            this.flush();
            if (!this.engine.isOutboundDone()) {
                this.engine.closeOutbound();
                this.runHandshake();
            } else if (!this.engine.isInboundDone()) {
                this.engine.closeInbound();
                this.runHandshake();
            }
        }
        finally {
            this.output.close();
        }
    }

    void flush() throws IOException {
        this.myNetworkBuffer.flip();
        this.networkWriteBuffer(this.myNetworkBuffer);
        this.myNetworkBuffer.compact();
    }

    private boolean runHandshake() throws IOException {
        boolean handshakeRan = false;
        while (this.processHandshake()) {
            handshakeRan = true;
        }
        return handshakeRan;
    }

    private boolean processHandshake() throws IOException {
        SSLEngineResult.HandshakeStatus hs = this.engine.getHandshakeStatus();
        logger.fine("processHandshake() hs = " + (Object)((Object)hs));
        switch (hs) {
            case NEED_TASK: {
                this.synchronousRunDelegatedTasks();
                return this.processHandshake();
            }
            case NEED_UNWRAP: {
                return this.handshakeUnwrap();
            }
            case NEED_WRAP: {
                return this.handshakeWrap();
            }
        }
        return false;
    }

    private void synchronousRunDelegatedTasks() {
        logger.fine("runDelegatedTasks()");
        Runnable r;
        while ((r = this.engine.getDelegatedTask()) != null) {
            logger.fine("Running a task: " + r);
            r.run();
        }
        return;
    }

    private boolean handshakeUnwrap() throws IOException {
        logger.fine("handshakeUnwrap()");
        if (!this.engine.isInboundDone() && this.peerNetworkBuffer.position() == 0 && this.networkReadBuffer(this.peerNetworkBuffer) < 0) {
            return false;
        }
        this.peerNetworkBuffer.flip();
        SSLEngineResult result = this.engine.unwrap(this.peerNetworkBuffer, this.peerApplicationBuffer);
        this.peerNetworkBuffer.compact();
        if (logger.isLoggable(Level.FINE)) {
            this.logResult(result);
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeFinished();
        }
        switch (result.getStatus()) {
            case CLOSED: {
                if (this.engine.isOutboundDone()) {
                    this.output.close();
                }
                return false;
            }
            case OK: {
                return true;
            }
            case BUFFER_UNDERFLOW: {
                return this.networkReadBuffer(this.peerNetworkBuffer) >= 0;
            }
        }
        return false;
    }

    private boolean handshakeWrap() throws IOException {
        logger.fine("handshakeWrap()");
        this.myApplicationBuffer.flip();
        SSLEngineResult result = this.engine.wrap(this.myApplicationBuffer, this.myNetworkBuffer);
        this.myApplicationBuffer.compact();
        if (logger.isLoggable(Level.FINE)) {
            this.logResult(result);
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeFinished();
        }
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            try {
                this.flush();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        } else {
            this.flush();
        }
        switch (result.getStatus()) {
            case CLOSED: {
                if (this.engine.isOutboundDone()) {
                    this.output.close();
                }
                return false;
            }
            case OK: {
                return true;
            }
        }
        return false;
    }

    private void logResult(SSLEngineResult result) {
        logger.fine("Result status=" + (Object)((Object)result.getStatus()) + " hss=" + (Object)((Object)result.getHandshakeStatus()) + " consumed = " + result.bytesConsumed() + " produced = " + result.bytesProduced());
    }

    private void handshakeFinished() {
        if (this.handshakeCallback != null) {
            this.handshakeCallback.handshakeCompleted();
        }
    }

    private void networkWriteBuffer(ByteBuffer buffer) throws IOException {
        byte[] bs = buffer.array();
        int off = buffer.position();
        int len = buffer.limit() - off;
        logger.fine("networkWriteBuffer(b, " + off + ", " + len + ")");
        this.output.write(bs, off, len);
        this.output.flush();
        buffer.position(buffer.limit());
    }

    private int networkReadBuffer(ByteBuffer buffer) throws IOException {
        int len;
        int off;
        byte[] bs = buffer.array();
        int n = this.input.read(bs, off = buffer.position(), len = buffer.limit() - off);
        if (n != -1) {
            buffer.position(off + n);
        }
        logger.fine("networkReadBuffer(b, " + off + ", " + len + ") = " + n);
        return n;
    }
}

