/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.ExitTarget;
import com.subgraph.orchid.misc.GuardedBy;
import java.util.concurrent.TimeoutException;

public class StreamExitRequest
implements ExitTarget {
    private final boolean isAddress;
    private final IPv4Address address;
    private final String hostname;
    private final int port;
    private final Object requestCompletionLock;
    @GuardedBy(value="requestCompletionLock")
    private CompletionStatus completionStatus;
    @GuardedBy(value="requestCompletionLock")
    private Stream stream;
    @GuardedBy(value="requestCompletionLock")
    private int streamOpenFailReason;
    @GuardedBy(value="this")
    private boolean isReserved;
    @GuardedBy(value="this")
    private int retryCount;
    @GuardedBy(value="this")
    private long specificTimeout;

    StreamExitRequest(Object requestCompletionLock, IPv4Address address, int port) {
        this(requestCompletionLock, true, "", address, port);
    }

    StreamExitRequest(Object requestCompletionLock, String hostname, int port) {
        this(requestCompletionLock, false, hostname, null, port);
    }

    private StreamExitRequest(Object requestCompletionLock, boolean isAddress, String hostname, IPv4Address address, int port) {
        this.requestCompletionLock = requestCompletionLock;
        this.isAddress = isAddress;
        this.hostname = hostname;
        this.address = address;
        this.port = port;
        this.completionStatus = CompletionStatus.NOT_COMPLETED;
    }

    @Override
    public boolean isAddressTarget() {
        return this.isAddress;
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public synchronized void setStreamTimeout(long timeout) {
        this.specificTimeout = timeout;
    }

    public synchronized long getStreamTimeout() {
        if (this.specificTimeout > 0L) {
            return this.specificTimeout;
        }
        if (this.retryCount < 2) {
            return 10000L;
        }
        return 15000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCompletedTimeout() {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.newStatus(CompletionStatus.TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExitFailed() {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.newStatus(CompletionStatus.EXIT_FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStreamOpenFailure(int reason) {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.streamOpenFailReason = reason;
            this.newStatus(CompletionStatus.STREAM_OPEN_FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCompletedSuccessfully(Stream stream) {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.stream = stream;
            this.newStatus(CompletionStatus.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterrupted() {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.newStatus(CompletionStatus.INTERRUPTED);
        }
    }

    private void newStatus(CompletionStatus newStatus) {
        if (this.completionStatus != CompletionStatus.NOT_COMPLETED) {
            throw new IllegalStateException("Attempt to set completion state to " + (Object)((Object)newStatus) + " while status is " + (Object)((Object)this.completionStatus));
        }
        this.completionStatus = newStatus;
        this.requestCompletionLock.notifyAll();
    }

    Stream getStream() throws OpenFailedException, TimeoutException, StreamConnectFailedException, InterruptedException {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            switch (this.completionStatus) {
                case NOT_COMPLETED: {
                    throw new IllegalStateException("Request not completed");
                }
                case EXIT_FAILURE: {
                    throw new OpenFailedException("Failure at exit node");
                }
                case TIMEOUT: {
                    throw new TimeoutException();
                }
                case STREAM_OPEN_FAILURE: {
                    throw new StreamConnectFailedException(this.streamOpenFailReason);
                }
                case INTERRUPTED: {
                    throw new InterruptedException();
                }
                case SUCCESS: {
                    return this.stream;
                }
            }
            throw new IllegalStateException("Unknown completion status");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetForRetry() {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            this.streamOpenFailReason = 0;
            this.completionStatus = CompletionStatus.NOT_COMPLETED;
        }
        ++this.retryCount;
        this.isReserved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleted() {
        Object object = this.requestCompletionLock;
        synchronized (object) {
            return this.completionStatus != CompletionStatus.NOT_COMPLETED;
        }
    }

    synchronized boolean reserveRequest() {
        if (this.isReserved) {
            return false;
        }
        this.isReserved = true;
        return true;
    }

    synchronized boolean isReserved() {
        return this.isReserved;
    }

    public String toString() {
        if (this.isAddress) {
            return this.address + ":" + this.port;
        }
        return this.hostname + ":" + this.port;
    }

    private static enum CompletionStatus {
        NOT_COMPLETED,
        SUCCESS,
        TIMEOUT,
        STREAM_OPEN_FAILURE,
        EXIT_FAILURE,
        INTERRUPTED;

    }
}

