/*
 * Decompiled with CFR 0.152.
 */
package ts.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tukaani.xz.XZInputStream;
import ts.internal.io.tar.TarEntry;
import ts.internal.io.tar.TarException;
import ts.internal.io.tar.TarInputStream;

public class ZipUtils {
    public static final String ZIP_EXTENSION = ".zip";
    public static final String TAR_GZ_EXTENSION = ".tar.gz";
    public static final String TAR_XZ_EXTENSION = ".tar.xz";
    private static final String BIN_FOLDER = "/bin";

    private ZipUtils() {
    }

    public static boolean isZipFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(ZIP_EXTENSION);
    }

    public static boolean isTarGZFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(TAR_GZ_EXTENSION);
    }

    public static boolean isTarXZFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(TAR_XZ_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File file, File destination) throws IOException {
        ZipInputStream in = null;
        OutputStream out = null;
        try {
            in = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String outFilename = entry.getName();
                File extracted = new File(destination, outFilename);
                if (entry.isDirectory()) {
                    extracted.mkdirs();
                    continue;
                }
                File baseDir = extracted.getParentFile();
                if (!baseDir.exists()) {
                    baseDir.mkdirs();
                }
                out = new FileOutputStream(extracted);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                extracted.setLastModified(entry.getTime());
                if (!extracted.getParent().contains(BIN_FOLDER)) continue;
                extracted.setExecutable(true);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void extractTarGZ(File file, File destination) throws IOException {
        ZipUtils.extractTar(file, destination, true);
    }

    public static void extractTarXZ(File file, File destination) throws IOException {
        ZipUtils.extractTar(file, destination, false);
    }

    private static void extractTar(File file, File destination, boolean tarGz) throws IOException {
        FilterInputStream in = null;
        OutputStream out = null;
        try {
            in = new TarInputStream(tarGz ? new GZIPInputStream(new FileInputStream(file)) : new XZInputStream((InputStream)new FileInputStream(file)));
            TarEntry entry = null;
            while ((entry = ((TarInputStream)in).getNextEntry()) != null) {
                String outFilename = entry.getName();
                switch (entry.getFileType()) {
                    case 53: {
                        File extractedDir = new File(destination, outFilename);
                        if (!extractedDir.isDirectory()) break;
                        extractedDir.mkdirs();
                        break;
                    }
                    case 48: {
                        int len;
                        File extractedFile = new File(destination, outFilename);
                        File baseDir = extractedFile.getParentFile();
                        if (!baseDir.exists()) {
                            baseDir.mkdirs();
                        }
                        out = new FileOutputStream(extractedFile);
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.close();
                        extractedFile.setLastModified(entry.getTime());
                        long mode = entry.getMode();
                        if ((mode & 0x40L) <= 0L) break;
                        extractedFile.setExecutable(true, (mode & 1L) == 0L);
                        break;
                    }
                    case 49: {
                        File linkFile = new File(destination, outFilename);
                        File linkBaseDir = linkFile.getParentFile();
                        if (!linkBaseDir.exists()) {
                            linkBaseDir.mkdirs();
                        }
                        Path target = Paths.get(entry.getLinkName(), new String[0]);
                        Files.createLink(linkFile.toPath(), target);
                        break;
                    }
                    case 50: {
                        File symLinkFile = new File(destination, outFilename);
                        File symLinkBaseDir = symLinkFile.getParentFile();
                        if (!symLinkBaseDir.exists()) {
                            symLinkBaseDir.mkdirs();
                        }
                        Path symTarget = Paths.get(entry.getLinkName(), new String[0]);
                        Files.createSymbolicLink(symLinkFile.toPath(), symTarget, new FileAttribute[0]);
                    }
                }
            }
        }
        catch (TarException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

