/*
 * Decompiled with CFR 0.152.
 */
package ts.utils;

import java.util.List;
import ts.client.completions.SymbolDisplayPart;

public class TypeScriptHelper {
    public static String getPrefix(String contents, int position) {
        char c;
        StringBuilder prefix = null;
        for (int i = position - 1; i >= 0 && Character.isJavaIdentifierPart(c = contents.charAt(i)); --i) {
            if (prefix == null) {
                prefix = new StringBuilder();
            }
            prefix.insert(0, c);
        }
        return prefix != null ? prefix.toString() : null;
    }

    public static String text(List<SymbolDisplayPart> parts, boolean withPre) {
        if (parts == null || parts.size() < 1) {
            return null;
        }
        StringBuilder html = new StringBuilder(withPre ? "<pre>" : "");
        for (SymbolDisplayPart part : parts) {
            html.append(part.getText());
        }
        if (withPre) {
            html.append("</pre>");
        }
        return html.toString();
    }

    public static String extractFunctionParameters(List<SymbolDisplayPart> parts) {
        if (parts == null || parts.size() < 1) {
            return null;
        }
        StringBuilder information = new StringBuilder("");
        boolean hasParam = false;
        for (SymbolDisplayPart part : parts) {
            if (part.isParameterName()) {
                information.append(part.getText());
                hasParam = true;
                continue;
            }
            if (!hasParam) continue;
            if (")".equals(part.getText())) break;
            information.append(part.getText());
        }
        information.append("");
        return information.toString();
    }
}

