/*
 * Decompiled with CFR 0.152.
 */
package ts.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import ts.OS;
import ts.utils.IOUtils;
import ts.utils.StringUtils;

public class ProcessHelper {
    private static final String PATH_ENV = "PATH";

    public static File findLocation(String fileName, OS os, String extension) {
        String fileNameWithExt = extension == null ? fileName : fileName + extension;
        String path = System.getenv(PATH_ENV);
        String[] paths = path.split("" + File.pathSeparatorChar, 0);
        ArrayList<String> directories = new ArrayList<String>();
        for (String p : paths) {
            directories.add(p);
        }
        if (os == OS.MacOS) {
            directories.add("/usr/local/bin");
        }
        for (String directory : directories) {
            File file = new File(directory, fileNameWithExt);
            if (!file.exists()) continue;
            return file;
        }
        return ProcessHelper.which(fileName, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File which(String fileName, OS os) {
        File file;
        String[] command = ProcessHelper.whichCommand(fileName, os);
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String foundFile = reader.readLine();
            if (StringUtils.isEmpty(foundFile)) {
                File file2 = null;
                IOUtils.closeQuietly(reader);
                return file2;
            }
            File f = new File(foundFile);
            file = f.exists() ? f : null;
            IOUtils.closeQuietly(reader);
        }
        catch (IOException e) {
            File file3 = null;
            return file3;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return file;
    }

    private static String[] whichCommand(String fileName, OS os) {
        return ProcessHelper.getCommand("where " + fileName, os);
    }

    public static String[] getCommand(String command, OS os) {
        String image;
        File defaultShell = ProcessHelper.defaultShell(os);
        String string = image = defaultShell.isAbsolute() ? defaultShell.getAbsolutePath() : defaultShell.getPath();
        if (os == OS.Windows) {
            return new String[]{image, "/c", command};
        }
        return new String[]{image, "-c", command};
    }

    private static final File defaultShell(OS os) {
        String shell = null;
        if (os == OS.Windows) {
            shell = System.getenv("ComSpec") != null && !"".equals(System.getenv("ComSpec").trim()) ? System.getenv("ComSpec").trim() : "cmd.exe";
        }
        if (StringUtils.isEmpty(shell)) {
            shell = System.getenv("SHELL") != null && !"".equals(System.getenv("SHELL").trim()) ? System.getenv("SHELL").trim() : "/bin/sh";
        }
        return new File(shell);
    }
}

