/*
 * Decompiled with CFR 0.152.
 */
package ts.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import ts.utils.IOUtils;

public class FileUtils {
    public static final String JS_EXTENSION = "js";
    public static final String TS_EXTENSION = "ts";
    public static final String JSX_EXTENSION = "jsx";
    public static final String TSX_EXTENSION = "tsx";
    public static final String MAP_EXTENSION = "map";
    public static final String DEFINITION_TS_EXTENSION = ".d.ts";
    public static final String TSCONFIG_START = "tsconfig";
    public static final String TSCONFIG_END = ".json";
    public static final String TSCONFIG_JSON = "tsconfig.json";
    public static final String JSCONFIG_JSON = "jsconfig.json";
    public static final String TSLINT_JSON = "tslint.json";
    public static final String NODE_MODULES = "node_modules";
    public static final String BOWER_COMPONENTS = "bower_components";

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String getTypeScriptFilename(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1 || index == fileName.length() - 1) {
            return null;
        }
        String ext = fileName.substring(index + 1);
        if (JS_EXTENSION.equals(ext)) {
            StringBuilder tsFileName = new StringBuilder(fileName.substring(0, index));
            tsFileName.append('.');
            tsFileName.append(TS_EXTENSION);
            return tsFileName.toString();
        }
        if (MAP_EXTENSION.equals(ext)) {
            return FileUtils.getTypeScriptFilename(fileName.substring(0, index));
        }
        return null;
    }

    public static boolean isJsOrJsMapFile(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1 || index == fileName.length() - 1) {
            return false;
        }
        String ext = fileName.substring(index + 1);
        if (JS_EXTENSION.equals(ext)) {
            return true;
        }
        if (MAP_EXTENSION.equals(ext)) {
            return FileUtils.isJsOrJsMapFile(fileName.substring(0, index));
        }
        return false;
    }

    public static String getPath(File file) {
        return FileUtils.getPath(file, true);
    }

    public static String getPath(File file, boolean normalize) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getPath();
        }
        return normalize ? FileUtils.normalizeSlashes(path) : null;
    }

    public static String normalizeSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String getContents(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            String string = IOUtils.toString(in, null);
            return string;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static boolean isTsConfigFile(String filename) {
        if (TSCONFIG_JSON.equals(filename)) {
            return true;
        }
        return filename.startsWith(TSCONFIG_START) && filename.endsWith(TSCONFIG_END);
    }
}

