/*
 * Decompiled with CFR 0.152.
 */
package ts.resources;

import java.io.File;
import ts.TypeScriptException;
import ts.client.completions.ICompletionEntryMatcher;
import ts.client.format.FormatCodeSettings;
import ts.cmd.tslint.TslintSettingsStrategy;
import ts.internal.repository.TypeScriptRepository;
import ts.nodejs.NodejsProcessHelper;
import ts.repository.ITypeScriptRepository;
import ts.repository.TypeScriptRepositoryException;
import ts.resources.ITypeScriptProjectSettings;
import ts.resources.SynchStrategy;

public class BasicTypeScriptProjectSettings
implements ITypeScriptProjectSettings {
    private final File nodejsInstallPath;
    private final SynchStrategy synchStrategy;
    private final ITypeScriptRepository repository;
    private ICompletionEntryMatcher completionEntryMatcher;
    private TslintSettingsStrategy tslintStrategy;
    private boolean enableTelemetry;
    private boolean disableAutomaticTypingAcquisition;

    public BasicTypeScriptProjectSettings(File nodejsInstallPath, File typeScriptDir) throws TypeScriptRepositoryException {
        this(nodejsInstallPath, typeScriptDir, SynchStrategy.RELOAD);
    }

    public BasicTypeScriptProjectSettings(File nodejsInstallPath, File typeScriptDir, SynchStrategy synchStrategy) throws TypeScriptRepositoryException {
        this.nodejsInstallPath = nodejsInstallPath;
        this.repository = new TypeScriptRepository(typeScriptDir);
        this.synchStrategy = synchStrategy;
    }

    @Override
    public SynchStrategy getSynchStrategy() {
        return this.synchStrategy;
    }

    @Override
    public File getNodejsInstallPath() {
        return this.nodejsInstallPath;
    }

    @Override
    public String getNodeVersion() {
        File nodejsFile = this.getNodejsInstallPath();
        return NodejsProcessHelper.getNodeVersion(nodejsFile);
    }

    @Override
    public File getTscFile() {
        return this.repository.getTscFile();
    }

    @Override
    public File getTypesScriptDir() {
        return this.repository.getTypesScriptDir();
    }

    @Override
    public File getTsserverPluginsFile() throws TypeScriptException {
        return this.repository.getTsserverPluginsFile();
    }

    @Override
    public File getTslintFile() throws TypeScriptException {
        return this.repository.getTslintFile();
    }

    @Override
    public ICompletionEntryMatcher getCompletionEntryMatcher() {
        return this.completionEntryMatcher;
    }

    public void setCompletionEntryMatcher(ICompletionEntryMatcher completionEntryMatcher) {
        this.completionEntryMatcher = completionEntryMatcher;
    }

    @Override
    public File getCustomTslintJsonFile() {
        return null;
    }

    @Override
    public TslintSettingsStrategy getTslintStrategy() {
        return this.tslintStrategy;
    }

    public void setTslintStrategy(TslintSettingsStrategy tslintStrategy) {
        this.tslintStrategy = tslintStrategy;
    }

    @Override
    public boolean isUseCodeSnippetsOnMethodSuggest() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public FormatCodeSettings getFormatOptions() {
        return null;
    }

    @Override
    public String getTypeScriptVersion() {
        return this.repository.getTypesScriptVersion();
    }

    @Override
    public boolean isEnableTelemetry() {
        return this.enableTelemetry;
    }

    public void setEnableTelemetry(boolean enableTelemetry) {
        this.enableTelemetry = enableTelemetry;
    }

    @Override
    public boolean isDisableAutomaticTypingAcquisition() {
        return this.disableAutomaticTypingAcquisition;
    }

    public void setDisableAutomaticTypingAcquisition(boolean disableAutomaticTypingAcquisition) {
        this.disableAutomaticTypingAcquisition = disableAutomaticTypingAcquisition;
    }
}

