/*
 * Decompiled with CFR 0.152.
 */
package ts.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import ts.TypeScriptException;
import ts.client.CodeEdit;
import ts.client.CommandNames;
import ts.client.FileSpan;
import ts.client.ITypeScriptServiceClient;
import ts.client.Location;
import ts.client.ScriptKindName;
import ts.client.codefixes.CodeAction;
import ts.client.completions.CompletionEntry;
import ts.client.completions.ICompletionEntryFactory;
import ts.client.configure.ConfigureRequestArguments;
import ts.client.diagnostics.DiagnosticEvent;
import ts.client.diagnostics.DiagnosticEventBody;
import ts.client.format.FormatCodeSettings;
import ts.client.jsdoc.TextInsertion;
import ts.client.navbar.NavigationBarItem;
import ts.client.navbar.NavigationBarItemRoot;
import ts.client.occurrences.OccurrencesResponseItem;
import ts.client.quickinfo.QuickInfo;
import ts.client.refactors.ApplicableRefactorInfo;
import ts.client.refactors.RefactorEditInfo;
import ts.client.references.ReferencesResponseBody;
import ts.client.rename.RenameResponseBody;
import ts.internal.LocationReader;
import ts.resources.INavbarListener;
import ts.resources.ITypeScriptFile;
import ts.resources.ITypeScriptProject;
import ts.resources.TypeScriptProject;
import ts.utils.CompletableFutureUtils;

public abstract class AbstractTypeScriptFile
implements ITypeScriptFile {
    private final ITypeScriptProject tsProject;
    private final ScriptKindName scriptKind;
    private boolean dirty;
    protected final Object synchLock = new Object();
    private boolean opened;
    private final List<INavbarListener> listeners;
    private NavigationBarItemRoot navbar;
    private FormatCodeSettings formatOptions;
    private boolean configureAlreadyDone;
    private boolean disableChanged;
    private CompletableFuture navbarPromise;

    public AbstractTypeScriptFile(ITypeScriptProject tsProject, ScriptKindName scriptKind) {
        this.tsProject = tsProject;
        this.scriptKind = scriptKind;
        this.listeners = new ArrayList<INavbarListener>();
        this.setDirty(false);
        this.configureAlreadyDone = false;
    }

    @Override
    public ITypeScriptProject getProject() {
        return this.tsProject;
    }

    @Override
    public ScriptKindName getScriptKind() {
        return this.scriptKind;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public Location getLocation(int position) throws TypeScriptException {
        return new LocationReader(this.getContents(), position).getLineOffset();
    }

    @Override
    public int getPosition(int line, int offset) throws TypeScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPosition(Location loc) throws TypeScriptException {
        return this.getPosition(loc.getLine(), loc.getOffset());
    }

    @Override
    public void open() throws TypeScriptException {
        ((TypeScriptProject)this.tsProject).openFile(this);
        this.opened = true;
    }

    @Override
    public void close() throws TypeScriptException {
        ((TypeScriptProject)this.tsProject).closeFile(this);
        this.opened = false;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    void setOpened(boolean opened) {
        this.opened = opened;
    }

    @Override
    public CompletableFuture<List<CompletionEntry>> completions(int position, ICompletionEntryFactory factory) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        Object prefix = null;
        return client.completions(this.getName(), line, offset, factory);
    }

    @Override
    public CompletableFuture<List<FileSpan>> definition(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.definition(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<QuickInfo> quickInfo(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.quickInfo(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<List<DiagnosticEvent>> geterr() throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        return client.geterr(new String[]{this.getName()}, 0);
    }

    @Override
    public CompletableFuture<List<CodeEdit>> format(int startPosition, int endPosition) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        this.ensureFormatCodeSettings(client);
        Location start = this.getLocation(startPosition);
        Location end = this.getLocation(endPosition);
        return client.format(this.getName(), start.getLine(), start.getOffset(), end.getLine(), end.getOffset());
    }

    private void ensureFormatCodeSettings(ITypeScriptServiceClient client) throws TypeScriptException {
        FormatCodeSettings oldFormatOptions = this.formatOptions;
        FormatCodeSettings newFormatOptions = this.getFormatOptions();
        if (!this.configureAlreadyDone || !newFormatOptions.equals(oldFormatOptions)) {
            this.configureAlreadyDone = true;
            client.configure(new ConfigureRequestArguments().setFile(this.getName()).setFormatOptions(this.formatOptions));
        }
    }

    @Override
    public CompletableFuture<DiagnosticEventBody> semanticDiagnosticsSync(Boolean includeLinePosition) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        return client.semanticDiagnosticsSync(this.getName(), includeLinePosition);
    }

    @Override
    public CompletableFuture<DiagnosticEventBody> syntacticDiagnosticsSync(Boolean includeLinePosition) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        return client.syntacticDiagnosticsSync(this.getName(), includeLinePosition);
    }

    @Override
    public FormatCodeSettings getFormatOptions() {
        this.formatOptions = this.tsProject.getProjectSettings().getFormatOptions();
        return this.formatOptions;
    }

    @Override
    public void setFormatOptions(FormatCodeSettings formatOptions) {
        this.formatOptions = formatOptions;
    }

    @Override
    public CompletableFuture<ReferencesResponseBody> references(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.references(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<List<OccurrencesResponseItem>> occurrences(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.occurrences(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<RenameResponseBody> rename(int position, Boolean findInComments, Boolean findInStrings) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.rename(this.getName(), line, offset, findInComments, findInStrings);
    }

    @Override
    public CompletableFuture<List<FileSpan>> implementation(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.implementation(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<TextInsertion> docCommentTemplate(int position) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(position);
        int line = location.getLine();
        int offset = location.getOffset();
        return client.docCommentTemplate(this.getName(), line, offset);
    }

    @Override
    public CompletableFuture<List<CodeAction>> getCodeFixes(int startPosition, int endPosition, List<Integer> errorCodes) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location startLocation = this.getLocation(startPosition);
        int startLine = startLocation.getLine();
        int startOffset = startLocation.getOffset();
        Location endLocation = this.getLocation(endPosition);
        int endLine = endLocation.getLine();
        int endOffset = endLocation.getOffset();
        return client.getCodeFixes(this.getName(), this, startLine, startOffset, endLine, endOffset, errorCodes);
    }

    @Override
    public void compileOnSaveEmitFile(Boolean forced) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
    }

    @Override
    public CompletableFuture<List<ApplicableRefactorInfo>> getApplicableRefactors(int startPosition, Integer endPosition) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location startLocation = this.getLocation(startPosition);
        int line = startLocation.getLine();
        int offset = startLocation.getOffset();
        if (endPosition == null) {
            return client.getApplicableRefactors(this.getName(), line, offset);
        }
        Location endLocation = this.getLocation(endPosition);
        int endLine = endLocation.getLine();
        int endOffset = endLocation.getOffset();
        return client.getApplicableRefactors(this.getName(), line, offset, endLine, endOffset);
    }

    @Override
    public CompletableFuture<RefactorEditInfo> getEditsForRefactor(int startPosition, Integer endPosition, String refactor, String action) throws TypeScriptException {
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        Location location = this.getLocation(startPosition);
        int line = location.getLine();
        int offset = location.getOffset();
        if (endPosition == null) {
            return client.getEditsForRefactor(this.getName(), line, offset, refactor, action);
        }
        Location endLocation = this.getLocation(endPosition);
        int endLine = endLocation.getLine();
        int endOffset = endLocation.getOffset();
        return client.getEditsForRefactor(this.getName(), line, offset, endLine, endOffset, refactor, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavbarListener(INavbarListener listener) {
        List<INavbarListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        if (this.navbar != null) {
            listener.navBarChanged(this.navbar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNavBarListeners(NavigationBarItemRoot navbar) {
        List<INavbarListener> list = this.listeners;
        synchronized (list) {
            for (INavbarListener listener : this.listeners) {
                listener.navBarChanged(navbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavbarListener(INavbarListener listener) {
        List<INavbarListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void refreshNavBar() throws TypeScriptException {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.synch();
        ITypeScriptServiceClient client = this.tsProject.getClient();
        CompletableFutureUtils.cancel(this.navbarPromise);
        this.navbarPromise = this.tsProject.canSupport(CommandNames.NavTree) ? client.navtree(this.getName(), this).thenAccept(item -> {
            this.navbar = new NavigationBarItemRoot((NavigationBarItem)item);
            this.fireNavBarListeners(this.navbar);
            this.navbarPromise = null;
        }) : client.navbar(this.getName(), this).thenAccept(item -> {
            this.navbar = new NavigationBarItemRoot((List<NavigationBarItem>)item);
            this.fireNavBarListeners(this.navbar);
            this.navbarPromise = null;
        });
    }

    @Override
    public NavigationBarItemRoot getNavBar() {
        return this.navbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synch() throws TypeScriptException {
        if (!this.isDirty()) {
            return;
        }
        switch (this.tsProject.getProjectSettings().getSynchStrategy()) {
            case RELOAD: {
                this.tsProject.getClient().updateFile(this.getName(), this.getContents());
                this.setDirty(false);
                break;
            }
            case CHANGE: {
                while (this.isDirty()) {
                    try {
                        Object object = this.synchLock;
                        synchronized (object) {
                            this.synchLock.wait(5L);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new TypeScriptException(e);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void setDisableChanged(boolean disableChanged) {
        this.disableChanged = disableChanged;
    }

    @Override
    public boolean isDisableChanged() {
        return this.disableChanged;
    }
}

