/*
 * Decompiled with CFR 0.152.
 */
package ts.repository;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import ts.internal.repository.TypeScriptRepository;
import ts.repository.ITypeScriptRepository;
import ts.repository.ITypeScriptRepositoryManager;
import ts.repository.TypeScriptRepositoryException;
import ts.utils.FileUtils;
import ts.utils.IOUtils;
import ts.utils.VersionHelper;

public class TypeScriptRepositoryManager
implements ITypeScriptRepositoryManager {
    private final Map<String, ITypeScriptRepository> repositories = new HashMap<String, ITypeScriptRepository>();
    private ITypeScriptRepository[] sortedRepositories;
    private ITypeScriptRepository defaultRepository;
    private static final Comparator<ITypeScriptRepository> REPOSITORY_COMPARATOR = new Comparator<ITypeScriptRepository>(){

        @Override
        public int compare(ITypeScriptRepository r1, ITypeScriptRepository r2) {
            return VersionHelper.versionCompare(r2.getTypesScriptVersion(), r1.getTypesScriptVersion());
        }
    };

    @Override
    public ITypeScriptRepository createDefaultRepository(File baseDir) throws TypeScriptRepositoryException {
        this.defaultRepository = this.createRepository(baseDir);
        return this.defaultRepository;
    }

    protected final void setDefaultRepository(ITypeScriptRepository repository) {
        this.defaultRepository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITypeScriptRepository createRepository(File baseDir) throws TypeScriptRepositoryException {
        Map<String, ITypeScriptRepository> map = this.repositories;
        synchronized (map) {
            TypeScriptRepository repository = new TypeScriptRepository(baseDir, this);
            this.repositories.put(repository.getName(), repository);
            this.reset();
            return repository;
        }
    }

    public void reset() {
        this.sortedRepositories = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITypeScriptRepository removeRepository(String name) {
        Map<String, ITypeScriptRepository> map = this.repositories;
        synchronized (map) {
            this.reset();
            return this.repositories.remove(name);
        }
    }

    @Override
    public ITypeScriptRepository getDefaultRepository() {
        return this.defaultRepository;
    }

    @Override
    public ITypeScriptRepository getRepository(String name) {
        return this.repositories.get(name);
    }

    @Override
    public ITypeScriptRepository[] getRepositories() {
        if (this.sortedRepositories == null) {
            ArrayList<ITypeScriptRepository> reps = new ArrayList<ITypeScriptRepository>(this.repositories.values());
            Collections.sort(reps, REPOSITORY_COMPARATOR);
            this.sortedRepositories = reps.toArray(new ITypeScriptRepository[reps.size()]);
        }
        return this.sortedRepositories;
    }

    public static File getTsserverFile(File typesScriptDir) {
        if (typesScriptDir.getName().equals("tsserver")) {
            return typesScriptDir;
        }
        return new File(typesScriptDir, "bin/tsserver");
    }

    public static File getTscFile(File typesScriptDir) {
        if (typesScriptDir.getName().equals("tsc")) {
            return typesScriptDir;
        }
        return new File(typesScriptDir, "bin/tsc");
    }

    public static File getTslintFile(File tslintScriptDir) {
        return new File(tslintScriptDir, "bin/tslint");
    }

    public static String getPackageJsonVersion(File baseDir) {
        File packageJsonFile = new File(baseDir, "package.json");
        try {
            JsonObject json = Json.parse((String)IOUtils.toString(new FileInputStream(packageJsonFile))).asObject();
            return json.getString("version", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void validateTypeScriptDir(File typesScriptDir) throws TypeScriptRepositoryException {
        File tsserverFile = TypeScriptRepositoryManager.getTsserverFile(typesScriptDir);
        if (!tsserverFile.exists()) {
            throw new TypeScriptRepositoryException(FileUtils.getPath(typesScriptDir) + " is not a valid TypeScript repository. Check the directory contains bin/tsserver.");
        }
    }

    public static File getTsserverPluginsFile(File typesScriptDir) {
        if (typesScriptDir.getName().equals("tsserver-plugins")) {
            return typesScriptDir;
        }
        return new File(typesScriptDir, "bin/tsserver-plugins");
    }
}

