/*
 * Decompiled with CFR 0.152.
 */
package ts.npm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import ts.OS;
import ts.utils.IOUtils;

public class NpmHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getVersions(String moduleName, OS os) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            String[] command = new String[]{os == OS.Windows ? "npm.cmd" : "npm", "view", "--json", moduleName, "versions"};
            Process p = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("\"")) continue;
                String version = line.substring(1, line.lastIndexOf(34));
                versions.add(0, version);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return versions;
    }

    public static String getNpmInstallCommand(String moduleName, String version) {
        StringBuilder cmd = new StringBuilder("npm install ");
        cmd.append(moduleName);
        if (version != null) {
            cmd.append("@");
            cmd.append(version);
        }
        return cmd.toString();
    }
}

