/*
 * Decompiled with CFR 0.152.
 */
package ts.nodejs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import ts.OS;
import ts.utils.FileUtils;
import ts.utils.IOUtils;
import ts.utils.ProcessHelper;
import ts.utils.StringUtils;

public class NodejsProcessHelper {
    private static final String NODE_FILENAME = "node";
    private static final String[] WINDOWS_NODE_PATHS = new String[]{"C:/Program Files/nodejs/node.exe".replace('/', File.separatorChar), "C:/Program Files (x86)/nodejs/node.exe".replace('/', File.separatorChar), "node"};
    private static final String[] MACOS_NODE_PATHS = new String[]{"/usr/local/bin/node", "/opt/local/bin/node", "node"};
    private static final String[] LINUX_NODE_PATHS = new String[]{"/usr/local/bin/node", "node"};

    private NodejsProcessHelper() {
    }

    public static String getNodejsPath(OS os) {
        String path = NodejsProcessHelper.getDefaultNodejsPath(os);
        if (path != null) {
            return path;
        }
        File nodeFile = NodejsProcessHelper.findNode(os);
        if (nodeFile != null) {
            return nodeFile.getAbsolutePath();
        }
        return NODE_FILENAME;
    }

    public static String getDefaultNodejsPath(OS os) {
        String[] paths = NodejsProcessHelper.getDefaultNodejsPaths(os);
        String path = null;
        for (int i = 0; i < paths.length; ++i) {
            path = paths[i];
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    public static String[] getDefaultNodejsPaths(OS os) {
        switch (os) {
            case Windows: {
                return WINDOWS_NODE_PATHS;
            }
            case MacOS: {
                return MACOS_NODE_PATHS;
            }
        }
        return LINUX_NODE_PATHS;
    }

    public static String[] getNodejsPaths(OS os) {
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(NodejsProcessHelper.getDefaultNodejsPaths(os)));
        File nodeFile = NodejsProcessHelper.findNode(os);
        if (nodeFile != null) {
            paths.add(0, nodeFile.getAbsolutePath());
        }
        return paths.toArray(StringUtils.EMPTY_STRING);
    }

    public static File findNode(OS os) {
        String extension = os == OS.Windows ? ".exe" : null;
        return ProcessHelper.findLocation(NODE_FILENAME, os, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeVersion(File nodejsFile) {
        if (nodejsFile != null) {
            BufferedReader reader = null;
            try {
                String command = FileUtils.getPath(nodejsFile) + " --version";
                Process p = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String string = reader.readLine();
                IOUtils.closeQuietly(reader);
                return string;
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
        return null;
    }
}

