/*
 * Decompiled with CFR 0.152.
 */
package ts.nodejs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ts.TypeScriptException;
import ts.nodejs.INodejsLaunchConfiguration;
import ts.nodejs.INodejsProcess;
import ts.nodejs.INodejsProcessListener;
import ts.utils.FileUtils;

public abstract class AbstractNodejsProcess
implements INodejsProcess {
    protected final File nodejsFile;
    protected final File projectDir;
    private final INodejsLaunchConfiguration launchConfiguration;
    protected final List<INodejsProcessListener> listeners;

    public AbstractNodejsProcess(File nodejsFile, File projectDir) throws TypeScriptException {
        this(nodejsFile, projectDir, null);
    }

    public AbstractNodejsProcess(File nodejsFile, File projectDir, INodejsLaunchConfiguration launchConfiguration) throws TypeScriptException {
        this.projectDir = this.checkProjectDir(projectDir);
        this.nodejsFile = this.checkNodejsFile(nodejsFile);
        this.listeners = new ArrayList<INodejsProcessListener>();
        this.launchConfiguration = launchConfiguration;
    }

    private File checkProjectDir(File projectDir) throws TypeScriptException {
        if (projectDir == null) {
            throw new TypeScriptException("project directory cannot be null");
        }
        if (!projectDir.exists()) {
            throw new TypeScriptException("Cannot find project directory " + FileUtils.getPath(projectDir));
        }
        return projectDir;
    }

    private File checkNodejsFile(File nodejsFile) throws TypeScriptException {
        if (nodejsFile == null) {
            return null;
        }
        if (!nodejsFile.exists()) {
            throw new TypeScriptException("Cannot find node file " + FileUtils.getPath(nodejsFile));
        }
        return nodejsFile;
    }

    protected List<String> createNodeArgs() {
        if (this.launchConfiguration == null) {
            return null;
        }
        return this.launchConfiguration.createNodeArgs();
    }

    protected Map<String, String> createNodeEnvironmentVariables() {
        if (this.launchConfiguration == null) {
            return null;
        }
        return this.launchConfiguration.createNodeEnvironmentVariables();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreateProcess(List<String> commands, File projectDir) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onCreate(this, commands, projectDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStartProcess(long startTime) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStopProcess() {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessage(String message) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onMessage(this, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyErrorProcess(String line) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onError(this, line);
            }
        }
    }
}

