/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.client.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.List;
import ts.client.CommandNames;
import ts.client.IPositionProvider;
import ts.client.Location;
import ts.client.navbar.NavigationBarItem;
import ts.internal.client.protocol.FileRequest;
import ts.internal.client.protocol.FileRequestArgs;
import ts.internal.client.protocol.GsonHelper;
import ts.internal.client.protocol.NavBarResponse;
import ts.internal.client.protocol.Response;

public class NavBarRequest
extends FileRequest<FileRequestArgs> {
    private final transient IPositionProvider positionProvider;

    public NavBarRequest(String fileName, IPositionProvider positionProvider) {
        super(CommandNames.NavBar.getName(), new FileRequestArgs(fileName, null));
        this.positionProvider = positionProvider;
    }

    @Override
    public Response<List<NavigationBarItem>> parseResponse(JsonObject json) {
        Gson gson = GsonHelper.DEFAULT_GSON;
        if (this.positionProvider != null) {
            gson = new GsonBuilder().registerTypeAdapter(Location.class, (Object)new InstanceCreator<Location>(){

                public Location createInstance(Type type) {
                    return new Location(NavBarRequest.this.positionProvider);
                }
            }).create();
        }
        return (Response)gson.fromJson((JsonElement)json, NavBarResponse.class);
    }
}

