/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.client.protocol;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import ts.client.CommandNames;
import ts.client.diagnostics.DiagnosticEvent;
import ts.internal.client.protocol.GeterrRequestArgs;
import ts.internal.client.protocol.IRequestEventable;
import ts.internal.client.protocol.Request;
import ts.internal.client.protocol.Response;

public class GeterrRequest
extends Request<GeterrRequestArgs>
implements IRequestEventable<DiagnosticEvent> {
    private final transient List<DiagnosticEvent> events = new ArrayList<DiagnosticEvent>();

    public GeterrRequest(String[] files, int delay) {
        super(CommandNames.Geterr.getName(), new GeterrRequestArgs(files, delay));
    }

    @Override
    public Response<?> parseResponse(JsonObject json) {
        return null;
    }

    @Override
    public List<String> getKeys() {
        String[] files = ((GeterrRequestArgs)super.getArguments()).getFiles();
        ArrayList<String> keys = new ArrayList<String>(files.length * 2);
        for (String file : files) {
            keys.add("syntaxDiag_" + file);
            keys.add("semanticDiag_" + file);
        }
        return keys;
    }

    @Override
    public boolean accept(DiagnosticEvent event) {
        this.events.add(event);
        return this.events.size() > 1;
    }

    @Override
    public List<DiagnosticEvent> getEvents() {
        return this.events;
    }
}

