/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.client.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.List;
import ts.client.CommandNames;
import ts.client.ITypeScriptServiceClient;
import ts.client.completions.CompletionEntry;
import ts.client.completions.ICompletionEntryFactory;
import ts.client.completions.ICompletionEntryMatcherProvider;
import ts.internal.client.protocol.CompletionsRequestArgs;
import ts.internal.client.protocol.CompletionsResponse;
import ts.internal.client.protocol.FileLocationRequest;
import ts.internal.client.protocol.Response;

public class CompletionsRequest
extends FileLocationRequest<CompletionsRequestArgs> {
    private final transient ICompletionEntryMatcherProvider matcherProvider;
    private final transient ITypeScriptServiceClient client;
    private final transient ICompletionEntryFactory factory;

    public CompletionsRequest(String fileName, int line, int offset, ICompletionEntryMatcherProvider matcherProvider, ITypeScriptServiceClient client, ICompletionEntryFactory factory) {
        super(CommandNames.Completions.getName(), new CompletionsRequestArgs(fileName, line, offset, null));
        this.matcherProvider = matcherProvider;
        this.client = client;
        this.factory = factory;
    }

    @Override
    public Response<List<CompletionEntry>> parseResponse(JsonObject json) {
        final String fileName = ((CompletionsRequestArgs)super.getArguments()).getFile();
        final int line = ((CompletionsRequestArgs)super.getArguments()).getLine();
        final int offset = ((CompletionsRequestArgs)super.getArguments()).getOffset();
        Gson gson = new GsonBuilder().registerTypeAdapter(CompletionEntry.class, (Object)new InstanceCreator<CompletionEntry>(){

            public CompletionEntry createInstance(Type type) {
                return CompletionsRequest.this.factory.create(CompletionsRequest.this.matcherProvider.getMatcher(), fileName, line, offset, CompletionsRequest.this.client);
            }
        }).create();
        return (Response)gson.fromJson((JsonElement)json, CompletionsResponse.class);
    }
}

