/*
 * Decompiled with CFR 0.152.
 */
package ts.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import ts.TypeScriptException;
import ts.internal.SequenceHelper;

public class FileTempHelper {
    private static final Stack<File> availableTempFileList = new Stack();
    private static final Map<Integer, File> seq_to_tempfile_name = new HashMap<Integer, File>();

    public static String updateTempFile(String newText, int seq) throws TypeScriptException {
        Writer writer = null;
        try {
            File tempFile = FileTempHelper.getTempFile(seq);
            writer = new FileWriter(tempFile);
            writer.write(newText);
            writer.flush();
            String string = tempFile.getCanonicalPath();
            return string;
        }
        catch (Exception e) {
            throw new TypeScriptException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new TypeScriptException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTempFile(int seq) throws IOException {
        File tempFile = null;
        Stack<File> stack = availableTempFileList;
        synchronized (stack) {
            if (!availableTempFileList.isEmpty()) {
                tempFile = availableTempFileList.pop();
            } else {
                tempFile = File.createTempFile("tmptsjava." + SequenceHelper.getTempSeq(), null);
                tempFile.deleteOnExit();
            }
            seq_to_tempfile_name.put(seq, tempFile);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTempFile(int seq) {
        Stack<File> stack = availableTempFileList;
        synchronized (stack) {
            File tempFile = seq_to_tempfile_name.remove(seq);
            if (tempFile != null) {
                availableTempFileList.push(tempFile);
            }
        }
    }
}

