/*
 * Decompiled with CFR 0.152.
 */
package ts.cmd.tsc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ts.cmd.AbstractOptions;
import ts.cmd.tsc.Plugin;
import ts.utils.BooleanUtils;

public class CompilerOptions
extends AbstractOptions {
    private Boolean allowJs;
    private Boolean allowSyntheticDefaultImports;
    private Boolean allowUnreachableCode;
    private Boolean allowUnusedLabels;
    private String charset;
    private Boolean declaration;
    private Boolean diagnostics;
    private Boolean emitBOM;
    private Boolean emitDecoratorMetadata;
    private Boolean experimentalDecorators;
    private Boolean forceConsistentCasingInFileNames;
    private Boolean help;
    private Boolean inlineSourceMap;
    private Boolean inlineSources;
    private Boolean init;
    private Boolean isolatedModules;
    private String jsx;
    private Boolean listEmittedFiles;
    private Boolean listFiles;
    private String locale;
    private String mapRoot;
    private String module;
    private String moduleResolution;
    private String newLine;
    private Boolean noEmit;
    private Boolean noEmitHelpers;
    private Boolean noEmitOnError;
    private Boolean noFallthroughCasesInSwitch;
    private Boolean noImplicitAny;
    private Boolean noImplicitReturns;
    private Boolean noImplicitUseStrict;
    private Boolean noLib;
    private Boolean noResolve;
    private String out;
    private String outDir;
    private String outFile;
    private Map<String, List<String>> paths;
    private Boolean preserveConstEnums;
    private Boolean pretty;
    private String project;
    private String reactNamespace;
    private Boolean removeComments;
    private String rootDir;
    private List<String> rootDirs;
    private Boolean skipDefaultLibCheck;
    private Boolean sourceMap;
    private String sourceRoot;
    private Boolean strictNullChecks;
    private Boolean stripInternal;
    private Boolean suppressExcessPropertyErrors;
    private Boolean suppressImplicitAnyIndexErrors;
    private String target;
    private Boolean traceResolution;
    private Boolean version;
    private Boolean watch;
    private List<Plugin> plugins;

    public CompilerOptions() {
    }

    public CompilerOptions(CompilerOptions options) {
        this.setAllowJs(options.allowJs);
        this.setAllowSyntheticDefaultImports(options.allowSyntheticDefaultImports);
        this.setAllowUnreachableCode(options.allowUnreachableCode);
        this.setAllowUnusedLabels(options.allowUnusedLabels);
        this.setCharset(options.charset);
        this.setDeclaration(options.declaration);
        this.setDiagnostics(options.diagnostics);
        this.setEmitBOM(options.emitBOM);
        this.setEmitDecoratorMetadata(options.emitDecoratorMetadata);
        this.setExperimentalDecorators(options.experimentalDecorators);
        this.setForceConsistentCasingInFileNames(options.forceConsistentCasingInFileNames);
        this.setHelp(options.help);
        this.setInlineSourceMap(options.inlineSourceMap);
        this.setInlineSources(options.inlineSources);
        this.setInit(options.init);
        this.setIsolatedModules(options.isolatedModules);
        this.setJsx(options.jsx);
        this.setListEmittedFiles(options.listEmittedFiles);
        this.setListFiles(options.listFiles);
        this.setLocale(options.locale);
        this.setMapRoot(options.mapRoot);
        this.setModule(options.module);
        this.setModuleResolution(options.moduleResolution);
        this.setNewLine(options.newLine);
        this.setNoEmit(options.noEmit);
        this.setNoEmitHelpers(options.noEmitHelpers);
        this.setNoEmitOnError(options.noEmitOnError);
        this.setNoFallthroughCasesInSwitch(options.noFallthroughCasesInSwitch);
        this.setNoImplicitAny(options.noImplicitAny);
        this.setNoImplicitReturns(options.noImplicitReturns);
        this.setNoImplicitUseStrict(options.noImplicitUseStrict);
        this.setNoLib(options.noLib);
        this.setNoResolve(options.noResolve);
        this.setOut(options.out);
        this.setOutDir(options.outDir);
        this.setOutFile(options.outFile);
        this.setPreserveConstEnums(options.preserveConstEnums);
        this.setPretty(options.pretty);
        this.setProject(options.project);
        this.setReactNamespace(options.reactNamespace);
        this.setRemoveComments(options.removeComments);
        this.setRootDir(options.rootDir);
        this.setSkipDefaultLibCheck(options.skipDefaultLibCheck);
        this.setSourceMap(options.sourceMap);
        this.setSourceRoot(options.sourceRoot);
        this.setStrictNullChecks(options.strictNullChecks);
        this.setStripInternal(options.stripInternal);
        this.setSuppressExcessPropertyErrors(options.suppressExcessPropertyErrors);
        this.setSuppressImplicitAnyIndexErrors(options.suppressImplicitAnyIndexErrors);
        this.setTarget(options.target);
        this.setTraceResolution(options.traceResolution);
        this.setVersion(options.version);
        this.setWatch(options.watch);
    }

    public Boolean isAllowJs() {
        return BooleanUtils.toBoolean(this.allowJs);
    }

    public void setAllowJs(Boolean allowJs) {
        this.allowJs = allowJs;
    }

    public boolean isAllowSyntheticDefaultImports() {
        return BooleanUtils.toBoolean(this.allowSyntheticDefaultImports);
    }

    public void setAllowSyntheticDefaultImports(Boolean allowSyntheticDefaultImports) {
        this.allowSyntheticDefaultImports = allowSyntheticDefaultImports;
    }

    public boolean isAllowUnreachableCode() {
        return BooleanUtils.toBoolean(this.allowUnreachableCode);
    }

    public void setAllowUnreachableCode(Boolean allowUnreachableCode) {
        this.allowUnreachableCode = allowUnreachableCode;
    }

    public boolean isAllowUnusedLabels() {
        return BooleanUtils.toBoolean(this.allowUnusedLabels);
    }

    public void setAllowUnusedLabels(Boolean allowUnusedLabels) {
        this.allowUnusedLabels = allowUnusedLabels;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isDeclaration() {
        return BooleanUtils.toBoolean(this.declaration);
    }

    public void setDeclaration(Boolean declaration) {
        this.declaration = declaration;
    }

    public boolean isDiagnostics() {
        return BooleanUtils.toBoolean(this.diagnostics);
    }

    public void setDiagnostics(Boolean diagnostics) {
        this.diagnostics = diagnostics;
    }

    public boolean isEmitBOM() {
        return BooleanUtils.toBoolean(this.emitBOM);
    }

    public void setEmitBOM(Boolean emitBOM) {
        this.emitBOM = emitBOM;
    }

    public boolean isEmitDecoratorMetadata() {
        return BooleanUtils.toBoolean(this.emitDecoratorMetadata);
    }

    public void setEmitDecoratorMetadata(Boolean emitDecoratorMetadata) {
        this.emitDecoratorMetadata = emitDecoratorMetadata;
    }

    public boolean isExperimentalDecorators() {
        return BooleanUtils.toBoolean(this.experimentalDecorators);
    }

    public void setExperimentalDecorators(Boolean experimentalDecorators) {
        this.experimentalDecorators = experimentalDecorators;
    }

    public boolean isForceConsistentCasingInFileNames() {
        return BooleanUtils.toBoolean(this.forceConsistentCasingInFileNames);
    }

    public void setForceConsistentCasingInFileNames(Boolean forceConsistentCasingInFileNames) {
        this.forceConsistentCasingInFileNames = forceConsistentCasingInFileNames;
    }

    public boolean isHelp() {
        return BooleanUtils.toBoolean(this.help);
    }

    public void setHelp(Boolean help) {
        this.help = help;
    }

    public boolean isInlineSourceMap() {
        return BooleanUtils.toBoolean(this.inlineSourceMap);
    }

    public void setInlineSourceMap(Boolean inlineSourceMap) {
        this.inlineSourceMap = inlineSourceMap;
    }

    public boolean isInlineSources() {
        return BooleanUtils.toBoolean(this.inlineSources);
    }

    public void setInlineSources(Boolean inlineSources) {
        this.inlineSources = inlineSources;
    }

    public boolean isInit() {
        return BooleanUtils.toBoolean(this.init);
    }

    public void setInit(Boolean init) {
        this.init = init;
    }

    public boolean isIsolatedModules() {
        return BooleanUtils.toBoolean(this.isolatedModules);
    }

    public void setIsolatedModules(Boolean isolatedModules) {
        this.isolatedModules = isolatedModules;
    }

    public String getJsx() {
        return this.jsx;
    }

    public void setJsx(String jsx) {
        this.jsx = jsx;
    }

    public boolean isListEmittedFiles() {
        return BooleanUtils.toBoolean(this.listEmittedFiles);
    }

    public void setListEmittedFiles(Boolean listEmittedFiles) {
        this.listEmittedFiles = listEmittedFiles;
    }

    public boolean isListFiles() {
        return BooleanUtils.toBoolean(this.listFiles);
    }

    public void setListFiles(Boolean listFiles) {
        this.listFiles = listFiles;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    public void setMapRoot(String mapRoot) {
        this.mapRoot = mapRoot;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModuleResolution() {
        return this.moduleResolution;
    }

    public void setModuleResolution(String moduleResolution) {
        this.moduleResolution = moduleResolution;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public boolean isNoEmit() {
        return BooleanUtils.toBoolean(this.noEmit);
    }

    public void setNoEmit(Boolean noEmit) {
        this.noEmit = noEmit;
    }

    public boolean isNoEmitHelpers() {
        return BooleanUtils.toBoolean(this.noEmitHelpers);
    }

    public void setNoEmitHelpers(Boolean noEmitHelpers) {
        this.noEmitHelpers = noEmitHelpers;
    }

    public boolean isNoEmitOnError() {
        return BooleanUtils.toBoolean(this.noEmitOnError);
    }

    public void setNoEmitOnError(Boolean noEmitOnError) {
        this.noEmitOnError = noEmitOnError;
    }

    public boolean isNoFallthroughCasesInSwitch() {
        return BooleanUtils.toBoolean(this.noFallthroughCasesInSwitch);
    }

    public void setNoFallthroughCasesInSwitch(Boolean noFallthroughCasesInSwitch) {
        this.noFallthroughCasesInSwitch = noFallthroughCasesInSwitch;
    }

    public boolean isNoImplicitAny() {
        return BooleanUtils.toBoolean(this.noImplicitAny);
    }

    public void setNoImplicitAny(Boolean noImplicitAny) {
        this.noImplicitAny = noImplicitAny;
    }

    public boolean isNoImplicitReturns() {
        return BooleanUtils.toBoolean(this.noImplicitReturns);
    }

    public void setNoImplicitReturns(Boolean noImplicitReturns) {
        this.noImplicitReturns = noImplicitReturns;
    }

    public boolean isNoImplicitUseStrict() {
        return BooleanUtils.toBoolean(this.noImplicitUseStrict);
    }

    public void setNoImplicitUseStrict(Boolean noImplicitUseStrict) {
        this.noImplicitUseStrict = noImplicitUseStrict;
    }

    public boolean isNoLib() {
        return BooleanUtils.toBoolean(this.noLib);
    }

    public void setNoLib(Boolean noLib) {
        this.noLib = noLib;
    }

    public boolean isNoResolve() {
        return BooleanUtils.toBoolean(this.noResolve);
    }

    public void setNoResolve(Boolean noResolve) {
        this.noResolve = noResolve;
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String out) {
        this.out = out;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public Set<String> getPathsKeys() {
        if (this.paths == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.paths.keySet());
    }

    public List<String> getPathsKeyValues(String pathsKey) {
        if (this.paths == null) {
            return Collections.emptyList();
        }
        List<String> values = this.paths.get(pathsKey);
        if (values == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(values);
    }

    public void setPaths(Map<String, List<String>> paths) {
        HashMap<String, List<String>> pathsCopy = new HashMap<String, List<String>>(paths.size());
        for (Map.Entry<String, List<String>> entry : paths.entrySet()) {
            pathsCopy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.paths = pathsCopy;
    }

    public boolean isPreserveConstEnums() {
        return BooleanUtils.toBoolean(this.preserveConstEnums);
    }

    public void setPreserveConstEnums(Boolean preserveConstEnums) {
        this.preserveConstEnums = preserveConstEnums;
    }

    public boolean isPretty() {
        return BooleanUtils.toBoolean(this.pretty);
    }

    public void setPretty(Boolean pretty) {
        this.pretty = pretty;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getReactNamespace() {
        return this.reactNamespace;
    }

    public void setReactNamespace(String reactNamespace) {
        this.reactNamespace = reactNamespace;
    }

    public boolean isRemoveComments() {
        return BooleanUtils.toBoolean(this.removeComments);
    }

    public void setRemoveComments(Boolean removeComments) {
        this.removeComments = removeComments;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public List<String> getRootDirs() {
        if (this.rootDirs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.rootDirs);
    }

    public void setRootDirs(List<String> rootDirs) {
        this.rootDirs = new ArrayList<String>(rootDirs);
    }

    public boolean isSkipDefaultLibCheck() {
        return BooleanUtils.toBoolean(this.skipDefaultLibCheck);
    }

    public void setSkipDefaultLibCheck(Boolean skipDefaultLibCheck) {
        this.skipDefaultLibCheck = skipDefaultLibCheck;
    }

    public boolean isSourceMap() {
        return BooleanUtils.toBoolean(this.sourceMap);
    }

    public void setSourceMap(Boolean sourceMap) {
        this.sourceMap = sourceMap;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public boolean isStrictNullChecks() {
        return BooleanUtils.toBoolean(this.strictNullChecks);
    }

    public void setStrictNullChecks(Boolean strictNullChecks) {
        this.strictNullChecks = strictNullChecks;
    }

    public boolean isStripInternal() {
        return BooleanUtils.toBoolean(this.stripInternal);
    }

    public void setStripInternal(Boolean stripInternal) {
        this.stripInternal = stripInternal;
    }

    public boolean isSuppressExcessPropertyErrors() {
        return BooleanUtils.toBoolean(this.suppressExcessPropertyErrors);
    }

    public void setSuppressExcessPropertyErrors(Boolean suppressExcessPropertyErrors) {
        this.suppressExcessPropertyErrors = suppressExcessPropertyErrors;
    }

    public boolean isSuppressImplicitAnyIndexErrors() {
        return BooleanUtils.toBoolean(this.suppressImplicitAnyIndexErrors);
    }

    public void setSuppressImplicitAnyIndexErrors(Boolean suppressImplicitAnyIndexErrors) {
        this.suppressImplicitAnyIndexErrors = suppressImplicitAnyIndexErrors;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isTraceResolution() {
        return BooleanUtils.toBoolean(this.traceResolution);
    }

    public void setTraceResolution(Boolean traceResolution) {
        this.traceResolution = traceResolution;
    }

    public boolean isVersion() {
        return BooleanUtils.toBoolean(this.version);
    }

    public void setVersion(Boolean version) {
        this.version = version;
    }

    public void setWatch(Boolean watch) {
        this.watch = watch;
    }

    public Boolean isWatch() {
        return BooleanUtils.toBoolean(this.watch);
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public void fillOptions(List<String> args) {
        if (this.isHelp()) {
            args.add("--help");
            return;
        }
        if (this.isVersion()) {
            args.add("--version");
            return;
        }
        this.fillOption("--allowJs", this.isAllowJs(), args);
        this.fillOption("--allowSyntheticDefaultImports", this.isAllowSyntheticDefaultImports(), args);
        this.fillOption("--allowUnreachableCode", this.isAllowUnreachableCode(), args);
        this.fillOption("--allowUnusedLabels", this.isAllowUnusedLabels(), args);
        this.fillOption("--charset", this.getCharset(), args);
        this.fillOption("--declaration", this.isDeclaration(), args);
        this.fillOption("--diagnostics", this.isDiagnostics(), args);
        this.fillOption("--emitBOM", this.isEmitBOM(), args);
        this.fillOption("--emitDecoratorMetadata", this.isEmitDecoratorMetadata(), args);
        this.fillOption("--experimentalDecorators", this.isExperimentalDecorators(), args);
        this.fillOption("--forceConsistentCasingInFileNames", this.isForceConsistentCasingInFileNames(), args);
        this.fillOption("--inlineSourceMap", this.isInlineSourceMap(), args);
        this.fillOption("--inlineSources", this.isInlineSources(), args);
        this.fillOption("--init", this.isInit(), args);
        this.fillOption("--isolatedModules", this.isIsolatedModules(), args);
        this.fillOption("--jsx", this.getJsx(), args);
        this.fillOption("--listEmittedFiles", this.isListEmittedFiles(), args);
        this.fillOption("--listFiles", this.isListFiles(), args);
        this.fillOption("--locale", this.getLocale(), args);
        this.fillOption("--mapRoot", this.getMapRoot(), args);
        this.fillOption("--module", this.getModule(), args);
        this.fillOption("--moduleResolution", this.getModuleResolution(), args);
        this.fillOption("--newLine", this.getNewLine(), args);
        this.fillOption("--noEmit", this.isNoEmit(), args);
        this.fillOption("--noEmitHelpers", this.isNoEmitHelpers(), args);
        this.fillOption("--noEmitOnError", this.isNoEmitOnError(), args);
        this.fillOption("--noEmitOnError", this.isNoEmitOnError(), args);
        this.fillOption("--noFallthroughCasesInSwitch", this.isNoFallthroughCasesInSwitch(), args);
        this.fillOption("--noImplicitAny", this.isNoImplicitAny(), args);
        this.fillOption("--noImplicitReturns", this.isNoImplicitReturns(), args);
        this.fillOption("--noImplicitUseStrict", this.isNoImplicitUseStrict(), args);
        this.fillOption("--noLib", this.isNoLib(), args);
        this.fillOption("--noResolve", this.isNoResolve(), args);
        this.fillOption("--out", this.getOut(), args);
        this.fillOption("--outDir", this.getOutDir(), args);
        this.fillOption("--outFile", this.getOutFile(), args);
        this.fillOption("--preserveConstEnums", this.isPreserveConstEnums(), args);
        this.fillOption("--pretty", this.isPretty(), args);
        this.fillOption("--project", this.getProject(), args);
        this.fillOption("--reactNamespace", this.getReactNamespace(), args);
        this.fillOption("--removeComments", this.isRemoveComments(), args);
        this.fillOption("--rootDir", this.getRootDir(), args);
        this.fillOption("--skipDefaultLibCheck", this.isSkipDefaultLibCheck(), args);
        this.fillOption("--sourceMap", this.isSourceMap(), args);
        this.fillOption("--strictNullChecks", this.isStrictNullChecks(), args);
        this.fillOption("--stripInternal", this.isStripInternal(), args);
        this.fillOption("--suppressExcessPropertyErrors", this.isSuppressExcessPropertyErrors(), args);
        this.fillOption("--suppressImplicitAnyIndexErrors", this.isSuppressImplicitAnyIndexErrors(), args);
        this.fillOption("--target", this.getTarget(), args);
        this.fillOption("--traceResolution", this.isTraceResolution(), args);
        this.fillOption("--version", this.isVersion(), args);
        this.fillOption("--watch", this.isWatch(), args);
    }
}

