/*
 * Decompiled with CFR 0.152.
 */
package ts.client.completions;

import java.util.List;
import java.util.concurrent.TimeUnit;
import ts.ScriptElementKind;
import ts.TypeScriptException;
import ts.client.IKindProvider;
import ts.client.ITypeScriptServiceClient;
import ts.client.TextSpan;
import ts.client.completions.CompletionEntryDetails;
import ts.client.completions.ICompletionEntryMatcher;
import ts.internal.matcher.LCSS;
import ts.utils.StringUtils;

public class CompletionEntry
implements IKindProvider {
    private static final int SUBWORDS_RANGE_START = -9000;
    private static final int minPrefixLengthForTypes = 1;
    private String name;
    private String kind;
    private String kindModifiers;
    private String sortText;
    private TextSpan replacementSpan;
    private Boolean hasAction;
    private Boolean isFunction;
    private int relevance;
    private final String fileName;
    private final int line;
    private final int offset;
    private final transient ICompletionEntryMatcher matcher;
    private final transient ITypeScriptServiceClient client;
    private List<CompletionEntryDetails> entryDetails;

    public CompletionEntry(ICompletionEntryMatcher matcher, String fileName, int line, int offset, ITypeScriptServiceClient client) {
        this.matcher = matcher;
        this.fileName = fileName;
        this.line = line;
        this.offset = offset;
        this.client = client;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getKindModifiers() {
        return this.kindModifiers;
    }

    public String getSortText() {
        return this.sortText;
    }

    public TextSpan getReplacementSpan() {
        return this.replacementSpan;
    }

    public boolean isFunction() {
        if (this.isFunction == null) {
            ScriptElementKind tsKind = ScriptElementKind.getKind(this.getKind());
            this.isFunction = tsKind != null && (ScriptElementKind.CONSTRUCTOR == tsKind || ScriptElementKind.FUNCTION == tsKind || ScriptElementKind.METHOD == tsKind);
        }
        return this.isFunction;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public boolean updatePrefix(String prefix) {
        Integer relevanceBoost = null;
        int[] bestSequence = null;
        if (StringUtils.isEmpty(prefix)) {
            relevanceBoost = 0;
        } else {
            bestSequence = this.matcher.bestSubsequence(this.name, prefix);
            if (bestSequence != null && bestSequence.length > 0) {
                relevanceBoost = 0;
                if (this.name.equals(prefix)) {
                    if (1 < prefix.length()) {
                        relevanceBoost = 224;
                    }
                } else if (this.name.equalsIgnoreCase(prefix)) {
                    if (1 < prefix.length()) {
                        relevanceBoost = 64;
                    }
                } else if (!this.startsWithIgnoreCase(prefix, this.name)) {
                    int score = LCSS.scoreSubsequence(bestSequence);
                    relevanceBoost = -9000 + score;
                }
            }
        }
        if (relevanceBoost != null) {
            this.relevance = relevanceBoost;
            return true;
        }
        return false;
    }

    private boolean startsWithIgnoreCase(String prefix, String name) {
        return prefix.toUpperCase().startsWith(name.toUpperCase());
    }

    public ICompletionEntryMatcher getMatcher() {
        return this.matcher;
    }

    public List<CompletionEntryDetails> getEntryDetails() throws TypeScriptException {
        if (this.entryDetails != null) {
            return this.entryDetails;
        }
        try {
            this.entryDetails = this.client.completionEntryDetails(this.fileName, this.line, this.offset, new String[]{this.name}, this).get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.entryDetails;
    }

    public boolean hasActions() {
        return this.hasAction != null && this.hasAction != false;
    }
}

