/*
 * Decompiled with CFR 0.152.
 */
package ts.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import ts.TypeScriptException;
import ts.TypeScriptNoContentAvailableException;
import ts.client.CodeEdit;
import ts.client.Event;
import ts.client.FileSpan;
import ts.client.IInterceptor;
import ts.client.IPositionProvider;
import ts.client.ITypeScriptClientListener;
import ts.client.ITypeScriptServiceClient;
import ts.client.ScriptKindName;
import ts.client.codefixes.CodeAction;
import ts.client.compileonsave.CompileOnSaveAffectedFileListSingleProject;
import ts.client.completions.CompletionEntry;
import ts.client.completions.CompletionEntryDetails;
import ts.client.completions.ICompletionEntryFactory;
import ts.client.completions.ICompletionEntryMatcherProvider;
import ts.client.configure.ConfigureRequestArguments;
import ts.client.diagnostics.DiagnosticEvent;
import ts.client.diagnostics.DiagnosticEventBody;
import ts.client.installtypes.BeginInstallTypesEventBody;
import ts.client.installtypes.EndInstallTypesEventBody;
import ts.client.installtypes.IInstallTypesListener;
import ts.client.jsdoc.TextInsertion;
import ts.client.navbar.NavigationBarItem;
import ts.client.navto.NavtoItem;
import ts.client.occurrences.OccurrencesResponseItem;
import ts.client.projectinfo.ProjectInfo;
import ts.client.quickinfo.QuickInfo;
import ts.client.refactors.ApplicableRefactorInfo;
import ts.client.refactors.RefactorEditInfo;
import ts.client.references.ReferencesResponseBody;
import ts.client.rename.RenameResponseBody;
import ts.client.signaturehelp.SignatureHelpItems;
import ts.cmd.tsc.CompilerOptions;
import ts.internal.FileTempHelper;
import ts.internal.SequenceHelper;
import ts.internal.client.protocol.ChangeRequest;
import ts.internal.client.protocol.CloseExternalProjectRequest;
import ts.internal.client.protocol.CloseRequest;
import ts.internal.client.protocol.CodeFixRequest;
import ts.internal.client.protocol.CompileOnSaveAffectedFileListRequest;
import ts.internal.client.protocol.CompileOnSaveEmitFileRequest;
import ts.internal.client.protocol.CompletionDetailsRequest;
import ts.internal.client.protocol.CompletionsRequest;
import ts.internal.client.protocol.ConfigureRequest;
import ts.internal.client.protocol.DefinitionRequest;
import ts.internal.client.protocol.DocCommentTemplateRequest;
import ts.internal.client.protocol.FormatRequest;
import ts.internal.client.protocol.GetApplicableRefactorsRequest;
import ts.internal.client.protocol.GetEditsForRefactorRequest;
import ts.internal.client.protocol.GetSupportedCodeFixesRequest;
import ts.internal.client.protocol.GeterrForProjectRequest;
import ts.internal.client.protocol.GeterrRequest;
import ts.internal.client.protocol.GsonHelper;
import ts.internal.client.protocol.IRequestEventable;
import ts.internal.client.protocol.ImplementationRequest;
import ts.internal.client.protocol.MessageType;
import ts.internal.client.protocol.NavBarRequest;
import ts.internal.client.protocol.NavToRequest;
import ts.internal.client.protocol.NavTreeRequest;
import ts.internal.client.protocol.OccurrencesRequest;
import ts.internal.client.protocol.OpenExternalProjectRequest;
import ts.internal.client.protocol.OpenExternalProjectRequestArgs;
import ts.internal.client.protocol.OpenRequest;
import ts.internal.client.protocol.ProjectInfoRequest;
import ts.internal.client.protocol.QuickInfoRequest;
import ts.internal.client.protocol.ReferencesRequest;
import ts.internal.client.protocol.ReloadRequest;
import ts.internal.client.protocol.RenameRequest;
import ts.internal.client.protocol.Request;
import ts.internal.client.protocol.Response;
import ts.internal.client.protocol.SemanticDiagnosticsSyncRequest;
import ts.internal.client.protocol.SignatureHelpRequest;
import ts.internal.client.protocol.SyntacticDiagnosticsSyncRequest;
import ts.nodejs.INodejsLaunchConfiguration;
import ts.nodejs.INodejsProcess;
import ts.nodejs.INodejsProcessListener;
import ts.nodejs.NodejsProcess;
import ts.nodejs.NodejsProcessAdapter;
import ts.nodejs.NodejsProcessManager;
import ts.repository.TypeScriptRepositoryManager;
import ts.utils.FileUtils;

public class TypeScriptServiceClient
implements ITypeScriptServiceClient {
    private static final String NO_CONTENT_AVAILABLE = "No content available.";
    private static final String TSSERVER_FILE_TYPE = "tsserver";
    private INodejsProcess process;
    private List<INodejsProcessListener> nodeListeners;
    private final List<ITypeScriptClientListener> listeners;
    private final List<IInstallTypesListener> installTypesListener;
    private final ReentrantReadWriteLock stateLock;
    private boolean dispose = false;
    private final Map<Integer, PendingRequestInfo> sentRequestMap;
    private final Map<String, PendingRequestEventInfo> receivedRequestMap;
    private List<IInterceptor> interceptors;
    private ICompletionEntryMatcherProvider completionEntryMatcherProvider;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        @Override
        public void onStart(INodejsProcess process) {
            TypeScriptServiceClient.this.fireStartServer();
        }

        @Override
        public void onStop(INodejsProcess process) {
            TypeScriptServiceClient.this.dispose();
            TypeScriptServiceClient.this.fireEndServer();
        }

        @Override
        public void onMessage(INodejsProcess process, String message) {
            if (message.startsWith("{")) {
                TypeScriptServiceClient.this.dispatchMessage(message);
            }
        }
    };
    private String cancellationPipeName;

    public TypeScriptServiceClient(File projectDir, File tsserverFile, File nodeFile) throws TypeScriptException {
        this(projectDir, tsserverFile, nodeFile, false, false, null, null, null);
    }

    public TypeScriptServiceClient(File projectDir, final File typescriptDir, File nodeFile, final boolean enableTelemetry, final boolean disableAutomaticTypingAcquisition, final String cancellationPipeName, final File tsserverPluginsFile, final TypeScriptServiceLogConfiguration logConfiguration) throws TypeScriptException {
        this(NodejsProcessManager.getInstance().create(projectDir, tsserverPluginsFile != null ? tsserverPluginsFile : TypeScriptRepositoryManager.getTsserverFile(typescriptDir), nodeFile, new INodejsLaunchConfiguration(){

            @Override
            public List<String> createNodeArgs() {
                ArrayList<String> args = new ArrayList<String>();
                if (enableTelemetry) {
                    args.add("--enableTelemetry");
                }
                if (disableAutomaticTypingAcquisition) {
                    args.add("--disableAutomaticTypingAcquisition");
                }
                if (tsserverPluginsFile != null) {
                    args.add("--typescriptDir");
                    args.add(FileUtils.getPath(typescriptDir));
                }
                if (cancellationPipeName != null) {
                    args.add("--cancellationPipeName");
                    args.add(String.valueOf(cancellationPipeName) + "*");
                }
                return args;
            }

            @Override
            public Map<String, String> createNodeEnvironmentVariables() {
                HashMap<String, String> environmentVariables = new HashMap<String, String>();
                if (logConfiguration != null) {
                    environmentVariables.put("TSS_LOG", "-level " + logConfiguration.level.name() + " -file " + logConfiguration.file);
                }
                return environmentVariables;
            }
        }, TSSERVER_FILE_TYPE), cancellationPipeName);
    }

    public TypeScriptServiceClient(INodejsProcess process, String cancellationPipeName) {
        this.listeners = new ArrayList<ITypeScriptClientListener>();
        this.installTypesListener = new ArrayList<IInstallTypesListener>();
        this.stateLock = new ReentrantReadWriteLock();
        this.sentRequestMap = new LinkedHashMap<Integer, PendingRequestInfo>();
        this.receivedRequestMap = new LinkedHashMap<String, PendingRequestEventInfo>();
        this.process = process;
        process.addProcessListener(this.listener);
        this.setCompletionEntryMatcherProvider(ICompletionEntryMatcherProvider.LCS_PROVIDER);
        this.cancellationPipeName = cancellationPipeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(String message) {
        JsonObject json = GsonHelper.parse(message).getAsJsonObject();
        JsonElement typeElement = json.get("type");
        if (typeElement != null) {
            MessageType messageType = MessageType.getType(typeElement.getAsString());
            if (messageType == null) {
                throw new IllegalStateException("Unknown response type message " + json);
            }
            switch (messageType) {
                case response: {
                    PendingRequestInfo pendingRequestInfo;
                    int seq = json.get("request_seq").getAsInt();
                    Map<Integer, PendingRequestInfo> map = this.sentRequestMap;
                    synchronized (map) {
                        pendingRequestInfo = this.sentRequestMap.remove(seq);
                    }
                    if (pendingRequestInfo == null) {
                        return;
                    }
                    Response responseMessage = pendingRequestInfo.requestMessage.parseResponse(json);
                    try {
                        this.handleResponse(responseMessage, message, pendingRequestInfo.startTime);
                        pendingRequestInfo.responseHandler.accept(responseMessage);
                    }
                    catch (RuntimeException runtimeException) {}
                    break;
                }
                case event: {
                    String event = json.get("event").getAsString();
                    if ("syntaxDiag".equals(event) || "semanticDiag".equals(event)) {
                        PendingRequestEventInfo pendingRequestEventInfo;
                        DiagnosticEvent response = (DiagnosticEvent)GsonHelper.DEFAULT_GSON.fromJson((JsonElement)json, DiagnosticEvent.class);
                        Map<String, PendingRequestEventInfo> map = this.receivedRequestMap;
                        synchronized (map) {
                            pendingRequestEventInfo = this.receivedRequestMap.remove(response.getKey());
                        }
                        if (pendingRequestEventInfo == null) break;
                        pendingRequestEventInfo.eventHandler.accept(response);
                        break;
                    }
                    if ("telemetry".equals(event)) {
                        JsonObject payload;
                        JsonObject telemetryData = json.get("body").getAsJsonObject();
                        JsonObject jsonObject = payload = telemetryData.has("payload") ? telemetryData.get("payload").getAsJsonObject() : null;
                        if (payload == null) break;
                        String telemetryEventName = telemetryData.get("telemetryEventName").getAsString();
                        this.fireLogTelemetry(telemetryEventName, payload);
                        break;
                    }
                    if ("beginInstallTypes".equals(event)) {
                        BeginInstallTypesEventBody data = (BeginInstallTypesEventBody)GsonHelper.DEFAULT_GSON.fromJson((JsonElement)json, BeginInstallTypesEventBody.class);
                        this.fireBeginInstallTypes(data);
                        break;
                    }
                    if (!"endInstallTypes".equals(event)) break;
                    EndInstallTypesEventBody data = (EndInstallTypesEventBody)GsonHelper.DEFAULT_GSON.fromJson((JsonElement)json, EndInstallTypesEventBody.class);
                    this.fireEndInstallTypes(data);
                }
            }
        }
    }

    @Override
    public void openFile(String fileName, String content) throws TypeScriptException {
        this.openFile(fileName, content, null);
    }

    @Override
    public void openFile(String fileName, String content, ScriptKindName scriptKindName) throws TypeScriptException {
        this.execute(new OpenRequest(fileName, null, content, scriptKindName), false);
    }

    @Override
    public void openExternalProject(String projectFileName, List<OpenExternalProjectRequestArgs.ExternalFile> rootFiles, CompilerOptions options) throws TypeScriptException {
        this.execute(new OpenExternalProjectRequest(projectFileName, rootFiles, options), false);
    }

    @Override
    public void closeExternalProject(String projectFileName) throws TypeScriptException {
        this.execute(new CloseExternalProjectRequest(projectFileName), false);
    }

    @Override
    public void closeFile(String fileName) throws TypeScriptException {
        this.execute(new CloseRequest(fileName), false);
    }

    @Override
    public void changeFile(String fileName, int line, int offset, int endLine, int endOffset, String insertString) throws TypeScriptException {
        this.execute(new ChangeRequest(fileName, line, offset, endLine, endOffset, insertString), false);
    }

    @Override
    public void updateFile(String fileName, String newText) throws TypeScriptException {
        int seq = SequenceHelper.getRequestSeq();
        String tempFileName = null;
        if (newText != null) {
            tempFileName = FileTempHelper.updateTempFile(newText, seq);
        }
        try {
            this.execute(new ReloadRequest(fileName, tempFileName, seq), true).get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e instanceof TypeScriptException) {
                throw (TypeScriptException)e;
            }
            throw new TypeScriptException(e);
        }
    }

    @Override
    public CompletableFuture<List<CompletionEntry>> completions(String fileName, int line, int offset) throws TypeScriptException {
        return this.completions(fileName, line, offset, ICompletionEntryFactory.DEFAULT);
    }

    @Override
    public CompletableFuture<List<CompletionEntry>> completions(String fileName, int line, int offset, ICompletionEntryFactory factory) throws TypeScriptException {
        return this.execute(new CompletionsRequest(fileName, line, offset, this.getCompletionEntryMatcherProvider(), this, factory), true);
    }

    @Override
    public CompletableFuture<List<CompletionEntryDetails>> completionEntryDetails(String fileName, int line, int offset, String[] entryNames, CompletionEntry completionEntry) throws TypeScriptException {
        return this.execute(new CompletionDetailsRequest(fileName, line, offset, null, entryNames), true);
    }

    @Override
    public CompletableFuture<List<FileSpan>> definition(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new DefinitionRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<SignatureHelpItems> signatureHelp(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new SignatureHelpRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<QuickInfo> quickInfo(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new QuickInfoRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<List<DiagnosticEvent>> geterr(String[] files, int delay) throws TypeScriptException {
        return this.execute(new GeterrRequest(files, delay), true);
    }

    @Override
    public CompletableFuture<List<DiagnosticEvent>> geterrForProject(String file, int delay, ProjectInfo projectInfo) throws TypeScriptException {
        return this.execute(new GeterrForProjectRequest(file, delay, projectInfo), true);
    }

    @Override
    public CompletableFuture<List<CodeEdit>> format(String fileName, int line, int offset, int endLine, int endOffset) throws TypeScriptException {
        return this.execute(new FormatRequest(fileName, line, offset, endLine, endOffset), true);
    }

    @Override
    public CompletableFuture<ReferencesResponseBody> references(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new ReferencesRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<List<OccurrencesResponseItem>> occurrences(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new OccurrencesRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<RenameResponseBody> rename(String file, int line, int offset, Boolean findInComments, Boolean findInStrings) throws TypeScriptException {
        return this.execute(new RenameRequest(file, line, offset, findInComments, findInStrings), true);
    }

    @Override
    public CompletableFuture<List<NavtoItem>> navto(String fileName, String searchValue, Integer maxResultCount, Boolean currentFileOnly, String projectFileName) throws TypeScriptException {
        return this.execute(new NavToRequest(fileName, searchValue, maxResultCount, currentFileOnly, projectFileName), true);
    }

    @Override
    public CompletableFuture<List<NavigationBarItem>> navbar(String fileName, IPositionProvider positionProvider) throws TypeScriptException {
        return this.execute(new NavBarRequest(fileName, positionProvider), true);
    }

    @Override
    public void configure(ConfigureRequestArguments arguments) throws TypeScriptException {
        this.execute(new ConfigureRequest(arguments), true);
    }

    @Override
    public CompletableFuture<ProjectInfo> projectInfo(String file, String projectFileName, boolean needFileNameList) throws TypeScriptException {
        return this.execute(new ProjectInfoRequest(file, needFileNameList), true);
    }

    @Override
    public CompletableFuture<DiagnosticEventBody> semanticDiagnosticsSync(String file, Boolean includeLinePosition) throws TypeScriptException {
        return this.execute(new SemanticDiagnosticsSyncRequest(file, includeLinePosition), true).thenApply(d -> new DiagnosticEventBody(file, (List)d));
    }

    @Override
    public CompletableFuture<DiagnosticEventBody> syntacticDiagnosticsSync(String file, Boolean includeLinePosition) throws TypeScriptException {
        return this.execute(new SyntacticDiagnosticsSyncRequest(file, includeLinePosition), true).thenApply(d -> new DiagnosticEventBody(file, (List)d));
    }

    @Override
    public CompletableFuture<Boolean> compileOnSaveEmitFile(String fileName, Boolean forced) throws TypeScriptException {
        return this.execute(new CompileOnSaveEmitFileRequest(fileName, forced), true);
    }

    @Override
    public CompletableFuture<List<CompileOnSaveAffectedFileListSingleProject>> compileOnSaveAffectedFileList(String fileName) throws TypeScriptException {
        return this.execute(new CompileOnSaveAffectedFileListRequest(fileName), true);
    }

    @Override
    public CompletableFuture<NavigationBarItem> navtree(String fileName, IPositionProvider positionProvider) throws TypeScriptException {
        return this.execute(new NavTreeRequest(fileName, positionProvider), true);
    }

    @Override
    public CompletableFuture<TextInsertion> docCommentTemplate(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new DocCommentTemplateRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<List<CodeAction>> getCodeFixes(String fileName, IPositionProvider positionProvider, int startLine, int startOffset, int endLine, int endOffset, List<Integer> errorCodes) throws TypeScriptException {
        return this.execute(new CodeFixRequest(fileName, startLine, startOffset, endLine, endOffset, errorCodes), true);
    }

    @Override
    public CompletableFuture<List<String>> getSupportedCodeFixes() throws TypeScriptException {
        return this.execute(new GetSupportedCodeFixesRequest(), true);
    }

    @Override
    public CompletableFuture<List<FileSpan>> implementation(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new ImplementationRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<List<ApplicableRefactorInfo>> getApplicableRefactors(String fileName, int line, int offset) throws TypeScriptException {
        return this.execute(new GetApplicableRefactorsRequest(fileName, line, offset), true);
    }

    @Override
    public CompletableFuture<List<ApplicableRefactorInfo>> getApplicableRefactors(String fileName, int startLine, int startOffset, int endLine, int endOffset) throws TypeScriptException {
        return this.execute(new GetApplicableRefactorsRequest(fileName, startLine, startOffset, endLine, endOffset), true);
    }

    @Override
    public CompletableFuture<RefactorEditInfo> getEditsForRefactor(String fileName, int line, int offset, String refactor, String action) throws TypeScriptException {
        return this.execute(new GetEditsForRefactorRequest(fileName, line, offset, refactor, action), true);
    }

    @Override
    public CompletableFuture<RefactorEditInfo> getEditsForRefactor(String fileName, int startLine, int startOffset, int endLine, int endOffset, String refactor, String action) throws TypeScriptException {
        return this.execute(new GetEditsForRefactorRequest(fileName, startLine, startOffset, endLine, endOffset, refactor, action), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> execute(final Request<?> request, boolean expectsResult) throws TypeScriptException {
        if (!expectsResult) {
            this.sendRequest(request);
            return null;
        }
        CompletableFuture result = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.tryCancelRequest(request);
                return super.cancel(mayInterruptIfRunning);
            }

            private void tryCancelRequest(Request<?> request2) {
                try {
                    this.cancelServerRequest(request2);
                }
                finally {
                    this.cancelClientRequest(request2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void cancelClientRequest(Request<?> request2) {
                if (request2 instanceof IRequestEventable) {
                    List<String> keys = ((IRequestEventable)((Object)request2)).getKeys();
                    Map map = TypeScriptServiceClient.this.receivedRequestMap;
                    synchronized (map) {
                        for (String key : keys) {
                            TypeScriptServiceClient.this.receivedRequestMap.remove(key);
                        }
                    }
                }
                Map map = TypeScriptServiceClient.this.sentRequestMap;
                synchronized (map) {
                    TypeScriptServiceClient.this.sentRequestMap.remove(request2.getSeq());
                }
            }

            private void cancelServerRequest(Request<?> request2) {
                if (TypeScriptServiceClient.this.cancellationPipeName != null) {
                    File tempFile = new File(String.valueOf(TypeScriptServiceClient.this.cancellationPipeName) + request2.getSeq());
                    try {
                        tempFile.createNewFile();
                        tempFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        if (request instanceof IRequestEventable) {
            Consumer<Event<?>> responseHandler = event -> {
                if (((IRequestEventable)((Object)request)).accept(event)) {
                    result.complete(((IRequestEventable)((Object)request)).getEvents());
                }
            };
            List<String> keys = ((IRequestEventable)((Object)request)).getKeys();
            PendingRequestEventInfo info = new PendingRequestEventInfo(request, responseHandler);
            Map<String, PendingRequestEventInfo> map = this.receivedRequestMap;
            synchronized (map) {
                for (String key : keys) {
                    this.receivedRequestMap.put(key, info);
                }
            }
        }
        Consumer<Response<?>> responseHandler = response -> {
            if (response.isSuccess()) {
                result.complete(response.getBody());
            } else {
                result.completeExceptionally(this.createException(response.getMessage()));
            }
        };
        int seq = request.getSeq();
        Map<Integer, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            this.sentRequestMap.put(seq, new PendingRequestInfo(request, responseHandler));
        }
        this.sendRequest(request);
        return result;
    }

    private TypeScriptException createException(String message) {
        if (NO_CONTENT_AVAILABLE.equals(message)) {
            return new TypeScriptNoContentAvailableException(message);
        }
        return new TypeScriptException(message);
    }

    private void sendRequest(Request<?> request) throws TypeScriptException {
        String req = GsonHelper.DEFAULT_GSON.toJson(request);
        this.handleRequest(request, req);
        this.getProcess().sendRequest(req);
    }

    private INodejsProcess getProcess() throws TypeScriptException {
        if (this.process == null) {
            throw new RuntimeException("unexpected error: process was stopped/killed before trying to use it again");
        }
        if (!this.process.isStarted()) {
            this.process.start();
        }
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientListener(ITypeScriptClientListener listener) {
        List<ITypeScriptClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientListener(ITypeScriptClientListener listener) {
        List<ITypeScriptClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartServer() {
        List<ITypeScriptClientListener> list = this.listeners;
        synchronized (list) {
            for (ITypeScriptClientListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEndServer() {
        List<ITypeScriptClientListener> list = this.listeners;
        synchronized (list) {
            for (ITypeScriptClientListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstallTypesListener(IInstallTypesListener listener) {
        List<IInstallTypesListener> list = this.installTypesListener;
        synchronized (list) {
            this.installTypesListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstallTypesListener(IInstallTypesListener listener) {
        List<IInstallTypesListener> list = this.installTypesListener;
        synchronized (list) {
            this.installTypesListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeginInstallTypes(BeginInstallTypesEventBody body) {
        List<IInstallTypesListener> list = this.installTypesListener;
        synchronized (list) {
            for (IInstallTypesListener listener : this.installTypesListener) {
                listener.onBegin(body);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEndInstallTypes(EndInstallTypesEventBody body) {
        List<IInstallTypesListener> list = this.installTypesListener;
        synchronized (list) {
            for (IInstallTypesListener listener : this.installTypesListener) {
                listener.onEnd(body);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLogTelemetry(String telemetryEventName, JsonObject payload) {
        List<IInstallTypesListener> list = this.installTypesListener;
        synchronized (list) {
            for (IInstallTypesListener listener : this.installTypesListener) {
                listener.logTelemetry(telemetryEventName, payload);
            }
        }
    }

    @Override
    public void addInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<IInterceptor>();
            }
            this.interceptors.add(interceptor);
        }
        finally {
            this.endWriteState();
        }
    }

    @Override
    public void removeInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors != null) {
                this.interceptors.remove(interceptor);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public void addProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.nodeListeners == null) {
                this.nodeListeners = new ArrayList<INodejsProcessListener>();
            }
            this.nodeListeners.add(listener);
            if (this.process != null) {
                this.process.addProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public void removeProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.nodeListeners != null && listener != null) {
                this.nodeListeners.remove(listener);
            }
            if (this.process != null) {
                this.process.removeProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.process != null) {
            this.process.join();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.dispose;
    }

    @Override
    public final void dispose() {
        this.beginWriteState();
        try {
            if (!this.isDisposed()) {
                this.dispose = true;
                System.out.println("dispose client - process=" + this.process);
                if (NodejsProcess.logProcessStopStack) {
                    Thread.dumpStack();
                }
                if (this.process != null) {
                    this.process.kill();
                }
                this.process = null;
            }
        }
        finally {
            this.endWriteState();
        }
    }

    private void beginReadState() {
        this.stateLock.readLock().lock();
    }

    private void endReadState() {
        this.stateLock.readLock().unlock();
    }

    private void beginWriteState() {
        this.stateLock.writeLock().lock();
    }

    private void endWriteState() {
        this.stateLock.writeLock().unlock();
    }

    public void setCompletionEntryMatcherProvider(ICompletionEntryMatcherProvider completionEntryMatcherProvider) {
        this.completionEntryMatcherProvider = completionEntryMatcherProvider;
    }

    public ICompletionEntryMatcherProvider getCompletionEntryMatcherProvider() {
        return this.completionEntryMatcherProvider;
    }

    private void handleRequest(Request<?> request, String json) {
        if (this.interceptors == null) {
            return;
        }
        for (IInterceptor interceptor : this.interceptors) {
            interceptor.handleRequest(request, json, this);
        }
    }

    private void handleResponse(Response<?> response, String json, long startTime) {
        if (this.interceptors == null) {
            return;
        }
        long ellapsedTime = TypeScriptServiceClient.getElapsedTimeInMs(startTime);
        for (IInterceptor interceptor : this.interceptors) {
            interceptor.handleResponse(response, json, ellapsedTime, this);
        }
    }

    private void handleError(String command, Throwable e, long startTime) {
        if (this.interceptors == null) {
            return;
        }
        long ellapsedTime = TypeScriptServiceClient.getElapsedTimeInMs(startTime);
        for (IInterceptor interceptor : this.interceptors) {
            interceptor.handleError(e, this, command, ellapsedTime);
        }
    }

    private static long getElapsedTimeInMs(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private static class PendingRequestEventInfo {
        Request<?> requestMessage;
        Consumer<Event<?>> eventHandler;
        long startTime;

        PendingRequestEventInfo(Request<?> requestMessage, Consumer<Event<?>> eventHandler) {
            this.requestMessage = requestMessage;
            this.eventHandler = eventHandler;
            this.startTime = System.nanoTime();
        }
    }

    private static class PendingRequestInfo {
        Request<?> requestMessage;
        Consumer<Response<?>> responseHandler;
        long startTime;

        PendingRequestInfo(Request<?> requestMessage, Consumer<Response<?>> responseHandler) {
            this.requestMessage = requestMessage;
            this.responseHandler = responseHandler;
            this.startTime = System.nanoTime();
        }
    }

    public static class TypeScriptServiceLogConfiguration {
        String file;
        TypeScriptServiceLogLevel level;

        public TypeScriptServiceLogConfiguration(String file, TypeScriptServiceLogLevel level) {
            this.file = file;
            this.level = level;
        }
    }

    public static enum TypeScriptServiceLogLevel {
        verbose,
        normal,
        terse,
        requestTime;

    }
}

