/*
 * Decompiled with CFR 0.152.
 */
package ts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ScriptElementKindModifier {
    none(""),
    publicMemberModifier("public"),
    privateMemberModifier("private"),
    protectedMemberModifier("protected"),
    exportedModifier("export"),
    ambientModifier("declare"),
    staticModifier("static"),
    abstractModifier("abstract");

    private static final Map<String, ScriptElementKindModifier> cache;
    private final String name;

    private ScriptElementKindModifier(String name) {
        this.name = name;
    }

    private static Map<String, ScriptElementKindModifier> initializeCache() {
        HashMap<String, ScriptElementKindModifier> cache = new HashMap<String, ScriptElementKindModifier>();
        ScriptElementKindModifier[] values = ScriptElementKindModifier.values();
        for (int i = 0; i < values.length; ++i) {
            ScriptElementKindModifier value = values[i];
            cache.put(value.getName(), value);
        }
        return cache;
    }

    public String getName() {
        return this.name;
    }

    public static ScriptElementKindModifier getKindModifier(String modifier) {
        return cache.get(modifier);
    }

    static {
        cache = Collections.unmodifiableMap(ScriptElementKindModifier.initializeCache());
    }
}

