/*
 * Decompiled with CFR 0.152.
 */
package ts.utils;

public class StringUtils {
    public static final String[] EMPTY_STRING = new String[0];
    public static final int INDEX_NOT_FOUND = -1;
    private static final int NOT_FOUND = -1;

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = StringUtils.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    static int indexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        int sz = cs.length();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < sz; ++i) {
            if (cs.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String normalizeSpace(String s) {
        char c;
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 1) {
            return "";
        }
        int st = 0;
        int off = 0;
        char[] val = s.toCharArray();
        int count = s.length();
        boolean parse = true;
        while (parse) {
            c = val[off + st];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            ++st;
        }
        parse = true;
        while (st < len && val[off + len - 1] <= ' ') {
            c = val[off + len - 1];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            --len;
        }
        return st > 0 || len < count ? s.substring(st, len) : s;
    }

    private static boolean isParse(int len, int st, char c) {
        return st < len && (c == ' ' || c == '\r' || c == '\n' || c == '\t');
    }
}

