/*
 * Decompiled with CFR 0.152.
 */
package ts.resources.jsonconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ts.cmd.tsc.CompilerOptions;
import ts.utils.BooleanUtils;
import ts.utils.StringUtils;

public class TsconfigJson {
    private static final String DEFAULT_TARGET = "es3";
    private static final String[] AVAILABLE_TARGETS = new String[]{"es3", "es5", "es6", "es2015", "es2016", "es2017", "esnext"};
    private static final String[] AVAILABLE_MODULES = new String[]{"none", "commonjs", "amd", "umd", "system", "es6", "es2015"};
    private static final String DEFAULT_MODULE_RESOLUTION = "classic";
    private static final String[] AVAILABLE_MODULE_RESOLUTIONS = new String[]{"node", "classic"};
    private CompilerOptions compilerOptions;
    private Boolean compileOnSave;
    private Boolean buildOnSave;
    private List<String> files;
    private List<String> exclude;
    private List<String> defaultExclude;

    public void setCompilerOptions(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public boolean isCompileOnSave() {
        return BooleanUtils.toBoolean(this.compileOnSave);
    }

    public void setCompileOnSave(Boolean compileOnSave) {
        this.compileOnSave = compileOnSave;
    }

    public boolean isBuildOnSave() {
        return BooleanUtils.toBoolean(this.buildOnSave);
    }

    public void setBuildOnSave(boolean buildOnSave) {
        this.buildOnSave = buildOnSave;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public boolean hasFiles() {
        return this.files != null;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public boolean hasExclude() {
        return this.exclude != null;
    }

    public boolean hasOutFile() {
        CompilerOptions options = this.getCompilerOptions();
        if (options == null) {
            return false;
        }
        return !StringUtils.isEmpty(options.getOutFile()) || !StringUtils.isEmpty(options.getOut());
    }

    public boolean hasPaths() {
        CompilerOptions options = this.getCompilerOptions();
        if (options == null) {
            return false;
        }
        return !options.getPathsKeys().isEmpty();
    }

    public boolean hasRootDirs() {
        CompilerOptions options = this.getCompilerOptions();
        if (options == null) {
            return false;
        }
        return !options.getRootDirs().isEmpty();
    }

    protected List<String> getDefaultOrDefinedExclude() {
        if (this.exclude != null) {
            return this.exclude;
        }
        if (this.defaultExclude != null) {
            return this.defaultExclude;
        }
        this.defaultExclude = new ArrayList<String>(Arrays.asList("node_modules", "bower_components"));
        CompilerOptions options = this.getCompilerOptions();
        if (options != null && !StringUtils.isEmpty(options.getOutDir())) {
            this.defaultExclude.add(options.getOutDir());
        }
        return this.defaultExclude;
    }

    public static TsconfigJson load(Reader reader) {
        return TsconfigJson.load(reader, TsconfigJson.class);
    }

    public static <T extends TsconfigJson> T load(Reader json, Class<T> classOfT) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        TsconfigJson o = (TsconfigJson)gson.fromJson(json, classOfT);
        if (o == null) {
            throw new JsonSyntaxException("JSON Syntax error");
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TsconfigJson> T load(InputStream in, Class<T> classOfT) {
        InputStreamReader isr = null;
        isr = new InputStreamReader(in);
        T t = TsconfigJson.load(isr, classOfT);
        return t;
        finally {
            if (isr != null) {
                try {
                    ((Reader)isr).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static TsconfigJson load(InputStream in) {
        return TsconfigJson.load(in, TsconfigJson.class);
    }

    public static String[] getAvailableTargets() {
        return AVAILABLE_TARGETS;
    }

    public static String getDefaultTarget() {
        return DEFAULT_TARGET;
    }

    public static String[] getAvailableModules() {
        return AVAILABLE_MODULES;
    }

    public static String[] getAvailableModuleResolutions() {
        return AVAILABLE_MODULE_RESOLUTIONS;
    }

    public static String getDefaultModuleResolution() {
        return DEFAULT_MODULE_RESOLUTION;
    }
}

