/*
 * Decompiled with CFR 0.152.
 */
package ts.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import ts.TypeScriptException;
import ts.client.CommandNames;
import ts.client.ISupportable;
import ts.client.ITypeScriptClientListener;
import ts.client.ITypeScriptServiceClient;
import ts.client.ScriptKindName;
import ts.client.TypeScriptServiceClient;
import ts.client.completions.ICompletionEntryMatcher;
import ts.client.completions.ICompletionEntryMatcherProvider;
import ts.client.diagnostics.DiagnosticEvent;
import ts.client.navto.NavtoItem;
import ts.client.projectinfo.ProjectInfo;
import ts.cmd.tsc.CompilerOptionCapability;
import ts.cmd.tsc.ITypeScriptCompiler;
import ts.cmd.tsc.TypeScriptCompiler;
import ts.cmd.tslint.ITypeScriptLint;
import ts.cmd.tslint.TypeScriptLint;
import ts.resources.AbstractTypeScriptFile;
import ts.resources.ITypeScriptFile;
import ts.resources.ITypeScriptProject;
import ts.resources.ITypeScriptProjectSettings;
import ts.utils.FileUtils;
import ts.utils.VersionHelper;

public class TypeScriptProject
implements ITypeScriptProject,
ICompletionEntryMatcherProvider {
    private static final ISupportable CANCELLATION_CAPABILITY = new ISupportable(){

        @Override
        public boolean canSupport(String version) {
            return VersionHelper.canSupport(version, "2.2.2");
        }
    };
    private final File projectDir;
    private ITypeScriptProjectSettings projectSettings;
    private ITypeScriptServiceClient client;
    private final Map<String, ITypeScriptFile> openedFiles;
    private ITypeScriptCompiler compiler;
    private final Map<String, Object> data;
    private final List<ITypeScriptClientListener> listeners;
    protected final Object serverLock = new Object();
    private ITypeScriptLint tslint;
    private final Map<ISupportable, Boolean> serverCapabilities;
    private Map<CompilerOptionCapability, Boolean> compilerCapabilities;
    private List<String> supportedCodeFixes;
    private ProjectInfo projectInfo;

    public TypeScriptProject(File projectDir, ITypeScriptProjectSettings projectSettings) {
        this.projectDir = projectDir;
        this.projectSettings = projectSettings;
        this.openedFiles = new HashMap<String, ITypeScriptFile>();
        this.data = new HashMap<String, Object>();
        this.listeners = new ArrayList<ITypeScriptClientListener>();
        this.serverCapabilities = new HashMap<ISupportable, Boolean>();
        this.compilerCapabilities = new HashMap<CompilerOptionCapability, Boolean>();
        this.projectInfo = null;
    }

    protected void setProjectSettings(ITypeScriptProjectSettings projectSettings) {
        this.projectSettings = projectSettings;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    void openFile(ITypeScriptFile tsFile) throws TypeScriptException {
        String name = tsFile.getName();
        String contents = tsFile.getContents();
        ScriptKindName scriptKind = tsFile.getScriptKind();
        this.getClient().openFile(name, contents, scriptKind);
        this.openedFiles.put(name, tsFile);
    }

    void closeFile(ITypeScriptFile tsFile) throws TypeScriptException {
        String name = tsFile.getName();
        this.getClient().closeFile(name);
        ((AbstractTypeScriptFile)tsFile).setOpened(false);
        this.openedFiles.remove(name);
    }

    @Override
    public List<String> getSupportedCodeFixes() throws TypeScriptException {
        if (this.supportedCodeFixes != null) {
            return this.supportedCodeFixes;
        }
        if (this.canSupport(CommandNames.GetSupportedCodeFixes)) {
            try {
                this.supportedCodeFixes = this.getClient().getSupportedCodeFixes().get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.supportedCodeFixes = new ArrayList<String>();
        }
        return this.supportedCodeFixes;
    }

    @Override
    public boolean canFix(Integer errorCode) {
        try {
            return this.getSupportedCodeFixes().contains(String.valueOf(errorCode));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ITypeScriptServiceClient getClient() throws TypeScriptException {
        Object object = this.serverLock;
        synchronized (object) {
            if (this.isServerDisposed()) {
                try {
                    this.client = this.createServiceClient(this.getProjectDir());
                    this.copyListeners();
                    this.onCreateClient(this.client);
                }
                catch (Exception e) {
                    if (e instanceof TypeScriptException) {
                        throw (TypeScriptException)e;
                    }
                    throw new TypeScriptException(e);
                }
            }
            return this.client;
        }
    }

    protected void onCreateClient(ITypeScriptServiceClient client) {
    }

    @Override
    public synchronized ITypeScriptFile getOpenedFile(String fileName) {
        return this.openedFiles.get(fileName);
    }

    @Override
    public void dispose() throws TypeScriptException {
        this.disposeServer();
        this.getProjectSettings().dispose();
    }

    protected ITypeScriptServiceClient createServiceClient(File projectDir) throws TypeScriptException {
        File nodeFile = this.getProjectSettings().getNodejsInstallPath();
        File typescriptDir = this.getProjectSettings().getTypesScriptDir();
        TypeScriptServiceClient client = new TypeScriptServiceClient(this.getProjectDir(), typescriptDir, nodeFile, this.getProjectSettings().isEnableTelemetry(), this.getProjectSettings().isDisableAutomaticTypingAcquisition(), this.getCancellationPipeName(), this.getProjectSettings().getTsserverPluginsFile(), null);
        client.setCompletionEntryMatcherProvider(this);
        return client;
    }

    private String getCancellationPipeName() {
        if (this.canSupport(CANCELLATION_CAPABILITY)) {
            String name = "eclipse-" + "tscancellation-" + UUID.randomUUID().toString() + ".sock";
            return FileUtils.getPath(new File(System.getProperty("java.io.tmpdir"), name));
        }
        return null;
    }

    protected ITypeScriptCompiler createCompiler() throws TypeScriptException {
        File nodeFile = this.getProjectSettings().getNodejsInstallPath();
        File tscFile = this.getProjectSettings().getTscFile();
        return this.createCompiler(tscFile, nodeFile);
    }

    protected ITypeScriptCompiler createCompiler(File tscFile, File nodejsFile) {
        return new TypeScriptCompiler(tscFile, nodejsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerListener(ITypeScriptClientListener listener) {
        List<ITypeScriptClientListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        this.copyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerListener(ITypeScriptClientListener listener) {
        Object object = this.listeners;
        synchronized (object) {
            this.listeners.remove(listener);
        }
        object = this.serverLock;
        synchronized (object) {
            if (this.hasClient()) {
                this.client.removeClientListener(listener);
            }
        }
    }

    protected boolean hasClient() {
        return this.client != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyListeners() {
        Object object = this.serverLock;
        synchronized (object) {
            if (this.hasClient()) {
                for (ITypeScriptClientListener listener : this.listeners) {
                    this.client.addClientListener(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeServer() {
        Object object = this.serverLock;
        synchronized (object) {
            if (!this.isServerDisposed() && this.hasClient()) {
                ArrayList<ITypeScriptFile> files = new ArrayList<ITypeScriptFile>(this.openedFiles.values());
                for (ITypeScriptFile openedFile : files) {
                    try {
                        openedFile.close();
                    }
                    catch (TypeScriptException e) {
                        e.printStackTrace();
                    }
                }
                this.client.dispose();
                this.client = null;
            }
        }
        this.serverCapabilities.clear();
        this.supportedCodeFixes = null;
    }

    @Override
    public void disposeCompiler() {
        if (this.compiler != null) {
            this.compiler.dispose();
            this.compiler = null;
            this.compilerCapabilities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getData(String key) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            return (T)this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, Object value) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            this.data.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServerDisposed() {
        Object object = this.serverLock;
        synchronized (object) {
            return this.client == null || this.client.isDisposed();
        }
    }

    @Override
    public ITypeScriptCompiler getCompiler() throws TypeScriptException {
        if (this.compiler == null) {
            this.compiler = this.createCompiler();
        }
        return this.compiler;
    }

    @Override
    public ITypeScriptLint getTslint() throws TypeScriptException {
        if (this.tslint == null) {
            this.tslint = this.createTslint();
        }
        return this.tslint;
    }

    @Override
    public void disposeTslint() {
        if (this.tslint != null) {
            this.tslint = null;
        }
    }

    protected ITypeScriptLint createTslint() throws TypeScriptException {
        File nodeFile = this.getProjectSettings().getNodejsInstallPath();
        File tslintFile = this.getProjectSettings().getTslintFile();
        File tslintJsonFile = this.getProjectSettings().getCustomTslintJsonFile();
        return this.createTslint(tslintFile, tslintJsonFile, nodeFile);
    }

    protected ITypeScriptLint createTslint(File tslintFile, File tslintJsonFile, File nodejsFile) {
        return new TypeScriptLint(tslintFile, tslintJsonFile, nodejsFile);
    }

    @Override
    public ITypeScriptProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    @Override
    public boolean canSupport(ISupportable command) {
        Boolean support = this.serverCapabilities.get(command);
        if (support == null) {
            support = command.canSupport(this.getProjectSettings().getTypeScriptVersion());
            this.serverCapabilities.put(command, support);
        }
        return support;
    }

    @Override
    public boolean canSupport(CompilerOptionCapability option) {
        Boolean support = this.compilerCapabilities.get((Object)option);
        if (support == null) {
            support = option.canSupport(this.getProjectSettings().getTypeScriptVersion());
            this.compilerCapabilities.put(option, support);
        }
        return support;
    }

    @Override
    public ICompletionEntryMatcher getMatcher() {
        return this.getProjectSettings().getCompletionEntryMatcher();
    }

    @Override
    public CompletableFuture<List<DiagnosticEvent>> geterrForProject(String file, int delay) throws TypeScriptException {
        try {
            ProjectInfo projectInfo = this.getClient().projectInfo(file, null, true).get(5000L, TimeUnit.MILLISECONDS);
            return this.getClient().geterrForProject(file, delay, projectInfo);
        }
        catch (Exception e) {
            if (e instanceof TypeScriptException) {
                throw (TypeScriptException)e;
            }
            throw new TypeScriptException(e);
        }
    }

    @Override
    public CompletableFuture<List<NavtoItem>> navto(String fileName, String searchValue, Integer maxResultCount, Boolean currentFileOnly, String projectFileName) throws TypeScriptException {
        ITypeScriptServiceClient client = this.getClient();
        return client.navto(fileName, searchValue, maxResultCount, currentFileOnly, projectFileName);
    }
}

