/*
 * Decompiled with CFR 0.152.
 */
package ts.nodejs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ts.TypeScriptException;
import ts.nodejs.INodejsLaunchConfiguration;
import ts.nodejs.INodejsProcess;
import ts.nodejs.INodejsProcessListener;
import ts.nodejs.NodejsProcess;
import ts.nodejs.NodejsProcessAdapter;

public class NodejsProcessManager {
    private static final NodejsProcessManager INSTANCE = new NodejsProcessManager();
    private final List<INodejsProcess> processes;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStart(INodejsProcess server) {
            List list = NodejsProcessManager.this.processes;
            synchronized (list) {
                NodejsProcessManager.this.processes.add(server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStop(INodejsProcess server) {
            List list = NodejsProcessManager.this.processes;
            synchronized (list) {
                NodejsProcessManager.this.processes.remove(server);
            }
        }
    };

    public static NodejsProcessManager getInstance() {
        return INSTANCE;
    }

    public NodejsProcessManager() {
        this.processes = new ArrayList<INodejsProcess>();
    }

    public INodejsProcess create(File projectDir, File tsFile, File nodejsFile, INodejsLaunchConfiguration configuration, String fileType) throws TypeScriptException {
        NodejsProcess process = new NodejsProcess(projectDir, tsFile, nodejsFile, configuration, fileType);
        process.addProcessListener(this.listener);
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<INodejsProcess> list = this.processes;
        synchronized (list) {
            for (INodejsProcess server : this.processes) {
                try {
                    server.kill();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.processes.clear();
        }
    }
}

