/*
 * Decompiled with CFR 0.152.
 */
package ts.nodejs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.TypeScriptException;
import ts.nodejs.AbstractNodejsProcess;
import ts.nodejs.INodejsLaunchConfiguration;
import ts.utils.FileUtils;

public class NodejsProcess
extends AbstractNodejsProcess {
    private final File tsFile;
    private Process process;
    private Thread outThread;
    private Thread errThread;
    private PrintStream out;
    private final Object outputLock;
    public static boolean logProcessStopStack = true;

    public NodejsProcess(File projectDir, File tsFile, File nodejsFile, INodejsLaunchConfiguration configuration, String fileType) throws TypeScriptException {
        super(nodejsFile, projectDir, configuration);
        this.tsFile = NodejsProcess.checkFile(tsFile, fileType);
        this.outputLock = new Object();
    }

    private static File checkFile(File tsFile, String fileType) throws TypeScriptException {
        if (tsFile == null) {
            throw new TypeScriptException("[" + fileType + "] file cannot be null");
        }
        if (!tsFile.exists()) {
            throw new TypeScriptException("Cannot find [" + fileType + "] file " + FileUtils.getPath(tsFile));
        }
        if (!tsFile.isFile()) {
            throw new TypeScriptException("[" + fileType + "] " + FileUtils.getPath(tsFile) + " is not a file.");
        }
        return tsFile;
    }

    @Override
    public void notifyErrorProcess(String line) {
        System.err.println(line);
    }

    @Override
    public void start() {
        try {
            List<String> commands = this.createCommands();
            ProcessBuilder builder = new ProcessBuilder(commands);
            Map<String, String> environmentVariables = this.createNodeEnvironmentVariables();
            if (environmentVariables != null) {
                for (Map.Entry<String, String> environmentVariableEntry : environmentVariables.entrySet()) {
                    builder.environment().put(environmentVariableEntry.getKey(), environmentVariableEntry.getValue());
                }
            }
            builder.directory(this.getProjectDir());
            this.process = builder.start();
            this.out = new PrintStream(this.process.getOutputStream(), false, StandardCharsets.UTF_8.name());
            this.errThread = new Thread(new StdErr());
            this.errThread.setDaemon(true);
            this.errThread.start();
            this.outThread = new Thread(new StdOut());
            this.outThread.setDaemon(true);
            this.outThread.start();
            Runtime.getRuntime().addShutdownHook(new ShutdownHookThread());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isStarted() {
        return this.process != null;
    }

    private List<String> createCommands() {
        List<String> commands = NodejsProcess.createNodeCommands(this.nodejsFile, this.tsFile);
        List<String> args = this.createNodeArgs();
        if (args != null) {
            commands.addAll(args);
        }
        return commands;
    }

    public static List<String> createNodeCommands(File nodejsFile, File tsFile) {
        LinkedList<String> commands = new LinkedList<String>();
        if (nodejsFile == null) {
            if (new File("/usr/local/bin/node").exists()) {
                commands.add("/usr/local/bin/node");
            } else if (new File("/opt/local/bin/node").exists()) {
                commands.add("/opt/local/bin/node");
            } else {
                commands.add("node");
            }
        } else {
            commands.add(nodejsFile.getPath());
        }
        try {
            commands.add(tsFile.getCanonicalPath());
        }
        catch (IOException e) {
            commands.add(tsFile.getPath());
        }
        return commands;
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public void kill() {
        if (logProcessStopStack) {
            System.out.println("kill nodejs process: projectDir=" + this.getProjectDir() + " nodejsFile=" + this.nodejsFile + " tsFile=" + this.tsFile + " - process=" + this.process);
            Thread.dumpStack();
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
            this.notifyStopProcess();
        }
        if (this.outThread != null) {
            this.outThread.interrupt();
            this.outThread = null;
        }
        if (this.errThread != null) {
            this.errThread.interrupt();
            this.errThread = null;
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.outThread != null) {
            this.outThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(String request) throws TypeScriptException {
        Object object = this.outputLock;
        synchronized (object) {
            this.out.println(request);
            this.out.flush();
        }
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        @Override
        public void run() {
            Process process = NodejsProcess.this.process;
            if (process != null) {
                NodejsProcess.this.kill();
            }
        }
    }

    private class StdErr
    implements Runnable {
        private StdErr() {
        }

        @Override
        public void run() {
            String line = null;
            InputStream is = NodejsProcess.this.process.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                while ((line = br.readLine()) != null) {
                    NodejsProcess.this.notifyErrorProcess(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class StdOut
    implements Runnable {
        private StdOut() {
        }

        @Override
        public void run() {
            try {
                try {
                    NodejsProcess.this.notifyStartProcess(0L);
                    BufferedReader r = new BufferedReader(new InputStreamReader(NodejsProcess.this.process.getInputStream(), StandardCharsets.UTF_8));
                    String line = null;
                    while ((line = r.readLine()) != null && NodejsProcess.this.process != null) {
                        NodejsProcess.this.notifyMessage(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (NodejsProcess.this.process != null) {
                    NodejsProcess.this.process.waitFor();
                }
                NodejsProcess.this.kill();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

