/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.repository;

import java.io.File;
import ts.repository.ITypeScriptRepository;
import ts.repository.TypeScriptRepositoryException;
import ts.repository.TypeScriptRepositoryManager;

public class TypeScriptRepository
implements ITypeScriptRepository {
    private final TypeScriptRepositoryManager manager;
    private File baseDir;
    private String name;
    private File typesScriptDir;
    private File tscFile;
    private File tslintFile;
    private String tslintName;
    private String typesScriptVersion;
    private String tslintVersion;
    private File tsserverPluginsFile;
    private String tslintLanguageServiceName;

    public TypeScriptRepository(File baseDir) throws TypeScriptRepositoryException {
        this(baseDir, null);
    }

    public TypeScriptRepository(File baseDir, TypeScriptRepositoryManager manager) throws TypeScriptRepositoryException {
        this.manager = manager;
        this.baseDir = baseDir;
        this.updateBaseDir(baseDir);
    }

    private void updateBaseDir(File baseDir) throws TypeScriptRepositoryException {
        File tslintLanguageServiceBaseDir;
        this.typesScriptDir = new File(baseDir, "node_modules/typescript");
        TypeScriptRepositoryManager.validateTypeScriptDir(this.typesScriptDir);
        this.tscFile = TypeScriptRepositoryManager.getTscFile(this.typesScriptDir);
        this.typesScriptVersion = TypeScriptRepositoryManager.getPackageJsonVersion(this.typesScriptDir);
        this.setName(this.generateName("TypeScript", this.typesScriptVersion));
        File tslintBaseDir = new File(baseDir, "node_modules/tslint");
        if (tslintBaseDir.exists()) {
            this.tslintFile = TypeScriptRepositoryManager.getTslintFile(tslintBaseDir);
            this.tslintVersion = TypeScriptRepositoryManager.getPackageJsonVersion(tslintBaseDir);
            this.tslintName = this.generateName("tslint", this.tslintVersion);
        }
        if ((tslintLanguageServiceBaseDir = new File(baseDir, "node_modules/tslint-language-service")).exists()) {
            String tslintLanguageServiceVersion = TypeScriptRepositoryManager.getPackageJsonVersion(tslintLanguageServiceBaseDir);
            this.tslintLanguageServiceName = this.generateName("tslint-language-service", tslintLanguageServiceVersion);
        }
        this.tsserverPluginsFile = new File(baseDir, "tsserver-plugins/bin/tsserver-plugins");
    }

    private String generateName(String prefix, String version) {
        StringBuilder name = new StringBuilder(prefix);
        name.append(" (");
        if (version != null) {
            name.append(version);
        }
        name.append(")");
        return name.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws TypeScriptRepositoryException {
        ITypeScriptRepository repository;
        ITypeScriptRepository iTypeScriptRepository = repository = this.manager != null ? this.manager.getRepository(name) : null;
        if (repository != null && !repository.equals(this)) {
            throw new TypeScriptRepositoryException("It already exists a TypeScript repository with the name " + name);
        }
        this.name = name;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public File getTypesScriptDir() {
        return this.typesScriptDir;
    }

    @Override
    public String getTypesScriptVersion() {
        return this.typesScriptVersion;
    }

    @Override
    public File getTscFile() {
        return this.tscFile;
    }

    @Override
    public String getTslintVersion() {
        return this.tslintVersion;
    }

    @Override
    public File getTslintFile() {
        return this.tslintFile;
    }

    @Override
    public String getTslintName() {
        return this.tslintName;
    }

    @Override
    public File getTsserverPluginsFile() {
        return this.tsserverPluginsFile;
    }

    @Override
    public String getTslintLanguageServiceName() {
        return this.tslintLanguageServiceName;
    }
}

