/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.matcher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SequenceFinder {
    private static final int[] EMPTY_SEQUENCE = new int[0];
    private List<int[]> curSequences = new LinkedList<int[]>();
    private List<int[]> nextSequences = new LinkedList<int[]>();
    private int pCompletion;
    private int pToken;
    private String completion;
    private String token;

    public SequenceFinder(String completion, String token) {
        this.completion = completion;
        this.token = token;
    }

    public List<int[]> findSeqeuences() {
        if (this.isConstantName(this.completion)) {
            this.rewriteCompletion();
        }
        int[] start = EMPTY_SEQUENCE;
        this.curSequences.add(start);
        this.pToken = 0;
        while (this.pToken < this.token.length()) {
            char t = this.token.charAt(this.pToken);
            for (int[] activeSequence : this.curSequences) {
                int startIndex;
                boolean mustmatch = false;
                this.pCompletion = startIndex = activeSequence.length == 0 ? 0 : activeSequence[activeSequence.length - 1] + 1;
                while (this.pCompletion < this.completion.length()) {
                    char c = this.completion.charAt(this.pCompletion);
                    if (!Character.isLetter(c)) {
                        if (c == t) {
                            this.addNewSubsequenceForNext(activeSequence);
                        } else {
                            mustmatch = true;
                        }
                    } else {
                        if (Character.isUpperCase(c)) {
                            mustmatch = true;
                        }
                        if (mustmatch && !this.isSameIgnoreCase(c, t)) {
                            this.jumpToEndOfWord();
                        } else if (this.isSameIgnoreCase(c, t)) {
                            this.addNewSubsequenceForNext(activeSequence);
                        }
                    }
                    ++this.pCompletion;
                }
            }
            this.curSequences = this.nextSequences;
            this.nextSequences = new LinkedList<int[]>();
            ++this.pToken;
        }
        Iterator<int[]> it = this.curSequences.iterator();
        while (it.hasNext()) {
            int[] candidate = it.next();
            if (candidate.length >= this.token.length()) continue;
            it.remove();
        }
        return this.curSequences;
    }

    private void addNewSubsequenceForNext(int[] activeSequence) {
        int[] copy = Arrays.copyOf(activeSequence, activeSequence.length + 1);
        copy[this.pToken] = this.pCompletion;
        this.nextSequences.add(copy);
    }

    private void rewriteCompletion() {
        StringBuilder sb = new StringBuilder();
        boolean toUpperCase = false;
        for (char c : this.completion.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                sb.append(toUpperCase ? Character.toUpperCase(c) : Character.toLowerCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
            toUpperCase = true;
        }
        this.completion = sb.toString();
    }

    private void jumpToEndOfWord() {
        char next;
        ++this.pCompletion;
        while (this.pCompletion < this.completion.length() && Character.isLetter(next = this.completion.charAt(this.pCompletion))) {
            if (Character.isUpperCase(next)) {
                --this.pCompletion;
                break;
            }
            ++this.pCompletion;
        }
    }

    private boolean isConstantName(String completion) {
        for (char c : completion.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameIgnoreCase(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        c2 = Character.isLowerCase(c2) ? Character.toUpperCase(c2) : Character.toLowerCase(c2);
        return c1 == c2;
    }
}

