/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.io.tar;

public class TarEntry
implements Cloneable {
    private String name;
    private long mode;
    private long time;
    private long size;
    private int type;
    int filepos;
    private String linkName;
    public static final int FILE = 48;
    public static final int DIRECTORY = 53;
    public static final int LINK = 49;
    public static final int SYM_LINK = 50;

    TarEntry(String name, int pos) {
        this.name = name;
        this.mode = 420L;
        this.type = 48;
        this.filepos = pos;
        this.time = System.currentTimeMillis() / 1000L;
    }

    public TarEntry(String name) {
        this(name, -1);
    }

    public int getFileType() {
        return this.type;
    }

    public long getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public void setFileType(int type) {
        this.type = type;
    }

    public void setMode(long mode) {
        this.mode = mode;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isDirectory() {
        return this.type == 53;
    }

    public boolean isLink() {
        return this.type == 49;
    }

    public boolean isSymbolicLink() {
        return this.type == 50;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
}

