/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.client.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import ts.client.diagnostics.Diagnostic;
import ts.client.diagnostics.DiagnosticWithLinePosition;
import ts.client.diagnostics.IDiagnostic;

public class GsonHelper {
    private static final JsonParser JSON_PARSER = new JsonParser();
    public static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(IDiagnostic.class, (Object)new DiagnosticAdapter()).create();

    public static JsonElement parse(String json) throws JsonSyntaxException {
        return JSON_PARSER.parse(json);
    }

    private static class DiagnosticAdapter
    implements JsonDeserializer<IDiagnostic> {
        private DiagnosticAdapter() {
        }

        public IDiagnostic deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.get("start").isJsonObject()) {
                    return (IDiagnostic)DEFAULT_GSON.fromJson(json, Diagnostic.class);
                }
                return (IDiagnostic)DEFAULT_GSON.fromJson(json, DiagnosticWithLinePosition.class);
            }
            return null;
        }
    }
}

